#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import os
import pickle

version = "1.0"

try:
    from glib import get_user_config_dir
except:
    def get_user_config_dir():
	home=os.environ['HOME']
	if home=='':
	    home="/home/user"
	cfg="%s/.config" % (home)

	return(cfg)

def ensure_dir():
    dir0=get_user_config_dir()
    dir=dir0+'/drlaunch'
    if not os.path.exists(dir):
	os.mkdir(dir)
    if not os.path.isdir(dir):
	raise Exception('Failed to ensure directory' + dir)

    return(dir)

def get_config_fn():
    dir=ensure_dir()
    ret=dir + '/config'

    return(ret)

class Config(object):
    def __init__(self, id):
	self.id=id

	self.size = (2,2)
	self.themebgsize = 96
	self.iconsize0 = 64
###	self.iconspace = 42	# For 4 icons (height)
##	self.iconspace = 36	# For 8 icons (width)

#	self.iconsize = 64
#	self.iconpadding = 12
#	self.iconmargin = 6

	self.apps=None
	self.indiv=True
	self.longpress=False
	self.animate=True
	self.nobg=False
	self.themebg=False

	self.setDefaultSizes()

	#self.maxsz=(8,4)

    def setSize(self, sz):
	maxsz=self.getMaxSize()
	sz2=(min(sz[0], maxsz[0]), min(sz[1], maxsz[1]))
	self.size=sz2

    def getSize(self):
	return(self.size)

    def setDefaultSizes(self):
	self.iconsize=64
	self.iconpadding=12
	self.iconmargin=6

    # Return the maximum grid size
    def getMaxSize(self):
	isf=self.getIconSizeFull()
	retx=int(800/isf)
	rety=int((480-60)/isf)
	maxsz=(retx, rety)
	return(maxsz)

    # Return the maxmimum icon size
    def getIconSizeRange(self):
	return((48,128))

    def getIconPaddingRange(self):
	return((0,32))

    def getIconMarginRange(self):
	return((0,16))

    def getIconSize(self):
	return(self.iconsize)

    def setIconSize(self, sz):
	self.iconsize=sz

    def getIconSpace(self):
	return((2*self.iconpadding) + (2*self.iconmargin))

    def getIconSizeFull(self):
	ret=self.iconsize + (2*self.iconpadding) + (2*self.iconmargin)
	return(ret)

    def getIconMargin(self):
	return(self.iconmargin)

    def setIconMargin(self, sz):
	self.iconmargin=sz

    def getIconPadding(self):
	return(self.iconpadding)

    def setIconPadding(self, sz):
	self.iconpadding=sz

    def setIndiv(self, indiv):
	self.indiv=indiv

    def getIndiv(self):
	return(self.indiv)

    def setLongpress(self, lp):
	self.longpress=lp

    def getLongpress(self):
	return(self.longpress)

    def setAnimate(self, ar):
	self.animate=ar

    def getAnimate(self):
	return(self.animate)

    def setNoBg(self, nobg):
	self.nobg=nobg

    def getNoBg(self):
	return(self.nobg)

    def setThemeBg(self, themebg):
	self.themebg=themebg

    def getThemeBg(self):
	return(self.themebg)

    def setApps(self, aps):
	""" apps is a dictionary of (x,y)=>appname """
	self.apps=aps

    def getApps(self):
	if self.apps==None:
	    tmp={
		(0,0):  'rtcom-call-ui',
		(0,1):  'rtcom-messaging-ui',
		(1,0):  'browser',
		(1,1):  'osso-addressbook',
		}
	    self.setApps(tmp)

	return(self.apps)

    def filterDefault(self, value, default):
	if value==default:
	    return(-1)
	else:
	    return(value)

    def provideDefault(self, value, default):
	if value==-1:
	    return(default)
	else:
	    return(value)

    def save(self):
	self.check_init()

	dt=self.load_all()

	if dt==None:
	    dt={
		'version':  7,
		'data':	{},
		}

	dt['data'][self.id]={
	    'size':	    self.getSize(),
	    'apps':	    self.getApps(),
	    'indiv':	    self.getIndiv(),
	    'longpress':    self.getLongpress(),
	    'animate':	    self.getAnimate(),
	    'nobg':	    self.getNoBg(),
	    'themebg':	    self.getThemeBg(),
	    'iconsize':	    self.filterDefault(self.getIconSize(), 64),
	    'iconpadding':  self.filterDefault(self.getIconPadding(), 12),
	    'iconmargin':   self.filterDefault(self.getIconMargin(), 6),
	    }

	fn=get_config_fn()

	st=pickle.dumps(dt)
	f=file(fn, 'w')
	f.write(st)
	f.close()

    def parse_v1(self, dt0):
	""" Convert a v1 config to v2 """
	ret={
	    'version':	    2,
	    'data':	    {},
	    }

	ret['data'][self.id]={
	    'size':	    dt0['size'],
	    'apps':	    dt0['apps'],
	    }

	return(ret)

    def parse_v2(self, dt):
	# Perhaps copy dt?

	dt['version']=3

	for i in dt['data']:
	    dt['data'][i]['indiv']=False
	    dt['data'][i]['size']=(dt['data'][i]['size'], dt['data'][i]['size'])
	    dt['data'][i]['longpress']=True

	return(dt)

    def parse_v3(self, dt):
	dt['version']=4

	for i in dt['data']:
	    dt['data'][i]['animate']=True

	return(dt)

    def parse_v4(self, dt):
	dt['version']=5

	for i in dt['data']:
	    dt['data'][i]['nobg']=False

	return(dt)

    def parse_v5(self, dt):
	dt['version']=6

	for i in dt['data']:
	    dt['data'][i]['themebg']=False

	return(dt)

    def parse_v6(self, dt):
	dt['version']=7

	for i in dt['data']:
	    dt['data'][i]['iconsize']=-1
	    dt['data'][i]['iconpadding']=-1
	    dt['data'][i]['iconmargin']=-1

	return(dt)

    def load_all(self):
	fn=get_config_fn()

	try:
	    f=file(fn, 'r')
	    st=f.read()
	    f.close()
	    ret=pickle.loads(st)

	    if ret==None:
		print "failed to load config"
		ret=None
	    else:
		if ret['version']==1:
		    ret=self.parse_v1(ret)

		if ret['version']==2:
		    ret=self.parse_v2(ret)

		if ret['version']==3:
		    ret=self.parse_v3(ret)

		if ret['version']==4:
		    ret=self.parse_v4(ret)

		if ret['version']==5:
		    ret=self.parse_v5(ret)

		if ret['version']==6:
		    ret=self.parse_v6(ret)
	except Exception, e:
	    print "config error:", e
	    ret=None

	return(ret)

    def load(self):
	self.check_init()

	fn=get_config_fn()

	dt0=self.load_all()

	if dt0==None or not dt0['data'].has_key(self.id):
	    return

	dt=dt0['data'][self.id]

	self.setSize(dt['size'])
	self.setApps(dt['apps'])
	self.setIndiv(dt['indiv'])
	self.setLongpress(dt['longpress'])
	self.setAnimate(dt['animate'])
	self.setNoBg(dt['nobg'])
	self.setThemeBg(dt['themebg'])
	self.setIconSize(self.provideDefault(dt['iconsize'], 64))
	self.setIconPadding(self.provideDefault(dt['iconpadding'], 12))
	self.setIconMargin(self.provideDefault(dt['iconmargin'], 6))

    def check_init(self):
	if self.id==None:
	    import sys

	    print "config.init() not done"
	    sys.exit(1)

def dump(obj):
    attrs=[attr for attr in dir(obj) if not callable(getattr(obj,attr))]

    print "obj:", obj
    for attr in attrs:
	if attr=='__gdoc__' or attr=='__doc__':
	    continue
	print "  ", attr, ":", getattr(obj, attr)

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

