#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import dbus

bus=None
proxy=None

def init():
    global bus, proxy

    if bus==None:
	bus=dbus.SessionBus()

    if proxy==None:
	proxy=bus.get_object('com.nokia.HildonDesktop.AppMgr',
	    '/com/nokia/HildonDesktop/AppMgr')

def launch(prog):
    global bus, proxy
    
    proxy.LaunchApplication(prog, 
	dbus_interface='com.nokia.HildonDesktop.AppMgr')

if __name__=="__main__":
    init()
    launch('wifieye')

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

