#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import os

from gettext import translation
#import locale

#from xdg.IconTheme import getIconPath

appdir="/usr/share/applications/hildon"

def readOneFn(fn):
    global appdir

    ret={
	'id':	    fn[:-8],
	'name':	    None,
	'exec':	    None,
	'icon':	    None,
	'iconpath': None,
	'domain':   None,
	'type':	    None,
	}

    fn2=appdir + '/' + fn

    try:
	f=open(fn2, 'rt')
    except:
	return(None)

    inde=False
    for line in f:
	line=line.strip()
	if line=='[Desktop Entry]':
	    inde=True
	    continue

	if inde==False:
	    continue

	# Reached another block
	if line.startswith('[') and inde:
	    break

	elif line.startswith('Name='):
	    l=line[5:]
	    ret['name']=l
	elif line.startswith('Exec='):
	    l=line[5:]
	    ret['exec']=l
	elif line.startswith('Icon='):
	    l=line[5:]
	    ret['icon']=l
	    # ret['iconpath']=getIconPath(l)
	elif line.startswith('X-Text-Domain='):
	    l=line[14:]
	    ret['domain']=l
	elif line.startswith('Type='):
	    l=line[5:]
	    ret['type']=l

    if ret['domain']!=None:
	try:
	    c=translation(ret['domain'])
	except IOError, e:
	    c=None

	if c!=None:
	    ret['name0']=ret['name']
	    ret['name']=c.gettext(ret['name0'])

    if ret['name']==None:
	ret['name']=ret['id']

    return(ret)

def readOne(name):
    fn=name + ".desktop"

    ret=readOneFn(fn)

    return(ret)

def scan():
    global appdir

    files=os.listdir(appdir)

    ret={}

    for f in files:
	if not f.endswith('.desktop'):
	    continue
	if f.startswith('catorise-'):
	    continue

	dt=readOneFn(f)

	if dt==None:
	    continue
	if dt['type']=='Daemon' or dt['type']=='daemon':
	    continue

	t=f[:-8]
	ret[t]=dt

    return(ret)

if __name__=="__main__":
    #locale.setlocale(locale.LC_ALL, '')
    print scan()

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

