#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of DrLaunch.
#
# DrLaunch is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DrLaunch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DrLaunch.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

from gtk import AboutDialog
import config
from about0 import HeAboutDialog
from portrait import FremantleRotation

class DlgAbout(HeAboutDialog, FremantleRotation):
    def __init__(self):
	HeAboutDialog.__init__(self)
	FremantleRotation.__init__(self, "DrlaunchPlugin",
	    mode=FremantleRotation.AUTOMATIC)

    @classmethod
    def present2(cls, parent):
	_copyright="""\
Copyright (C) 2010 Stefanos Harhalakis <v13@v13.gr>
Copyright (C) 2005-2010 Thomas Perl and the gPodder Team (for about0.py
and portrait.py)
"""
	_description="""
DrLaunch is a desktop launcher widget that
supports portrait mode by rotating program
icons. Whenever the device is rotated, icons
are also rotated.

Thanks to Thomas Perl and the gPodder Team.
"""

	_license="""\
Send bug reports and feature requests to Stefanos Harhalakis <v13@v13.gr>

DrLaunch is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DrLaunch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DrLaunch.  If not, see <http://www.gnu.org/licenses/>.

DrLaunch uses a modified version of about.py from gpodder which is also
distributed under the terms of the GPLv3 license. It also uses a
modified version of portrait.py from gpodder which is also distributed
under the terms of the GPLv3 license.
"""

	args={
	"app_name":	    "DrLaunch",
	"version":	    config.version,
	"copyright":	    _copyright + "\n" + _license,
	"description":	    _description,
	"bugtracker_url":   "mailto:v13@v13.gr",
	"parent":	    parent,
	}

	cls.present(**args)

    def set_icon_name(self, icon_name):
	pass

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

