#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import gtk
import gobject
import hildon
import time

from hildon import StackableWindow
#from portrait import FremantleRotation
#from xdg.IconTheme import getIconPath

#import config
import apps
from icon import Icon, getIcon
from icongrid import IconGridWidget

class WinConfig(StackableWindow):
    def __init__(self, config, *args):
	StackableWindow.__init__(self)

	self.config=config

	self.setupUi()

    def setupUi(self):
	self.igw=IconGridWidget(True, self.config)
#	self.igw.do_realize()
#	self.igw.setSize(config.getSize())

	hbox=gtk.HBox()
	self.add(hbox)

	# Add the icongrid
	hbox.add(self.igw)

	# Now go for the right side
	al=gtk.Alignment(yscale=0)
	hbox.add(al)

	vbox=gtk.VBox()
#	hbox.add(vbox)
	al.add(vbox)

	maxsz=self.config.getMaxSize()

	# ----------------------------------------------
	vbox.add(gtk.Label('Width:'))

	hbox2=gtk.HBox()
	vbox.add(hbox2)

	self.butsSizeX=[]
	self.butsSize=self.butsSizeX # For now
	for i in xrange(maxsz[0]):
	    but=hildon.GtkToggleButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
	    but.set_label("%s" % (i+1,))
	    but.connect('toggled', self.slotButtonSizeX, i)

	    self.butsSizeX.append(but)

	    hbox2.add(but)

	# ----------------------------------------------
	vbox.add(gtk.Label('Height:'))

	hbox2=gtk.HBox()
	vbox.add(hbox2)

	self.butsSizeY=[]
	for i in xrange(maxsz[1]):
	    but=hildon.GtkToggleButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
	    but.set_label("%s" % (i+1,))
	    but.connect('toggled', self.slotButtonSizeY, i)

	    self.butsSizeY.append(but)

	    hbox2.add(but)

	but=hildon.CheckButton(
		gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
	but.set_label("Rotate icons individually")
	but.connect('toggled', self.slotButtonRotateIndividually)
	self.buttonRotateIndividually=but
	vbox.add(but)

	but=hildon.CheckButton(
		gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
	but.set_label("Require long press")
#	but.connect('toggled', self.slotButtonLongpress)
	self.buttonRequireLongpress=but
	vbox.add(but)

	self.igw.connect('long-press', self.slotLongpress)
	self.igw.connect('click', self.slotLongpress)

	self.ignore_toggle=False

	self.setSize(self.config.getSize())
	self.setIndiv(self.config.getIndiv())
	self.setLongpress(self.config.getLongpress())

    def slotLongpress(self, sender, icon):
	self.doConfig(icon)

    def slotButtonSizeX(self, sender, id):
	if self.getIndiv():
	    old=self.getSize()
	    sz=(id+1, old[1])
	else:
	    sz=(id+1, id+1)

	self.setSize(sz)
	
    def slotButtonSizeY(self, sender, id):
	old=self.getSize()
	sz=(old[0], id+1)
	self.setSize(sz)
	
    def slotButtonRotateIndividually(self, sender):
	but=self.buttonRotateIndividually
	self.setIndiv(but.get_active())

#    def slotButtonLongpress(self, sender):
#	but=self.buttonRequireLongpress
#	self.set

    def setSize(self, sz):
	if self.ignore_toggle:
	    return

	self.ignore_toggle=True

	maxsz=self.config.getMaxSize()

	id=sz[0]-1

	for i in xrange(maxsz[0]):
	    but=self.butsSizeX[i]
	    but.set_active(i==id)

	id=sz[1]-1

	for i in xrange(maxsz[1]):
	    but=self.butsSizeY[i]
	    but.set_active(i==id)

	self.ignore_toggle=False

	self.igw.setSize(sz)

	self.igw.queue_draw()

    def getSize(self):
	return(self.igw.getSize())

    def getIndiv(self):
	ret=self.buttonRotateIndividually.get_active()

	return(ret)

    def setIndiv(self, indiv):
	if indiv:
	    for i in self.butsSizeY:
		i.set_sensitive(True)
	else:
	    for i in self.butsSizeY:
		i.set_sensitive(False)
	    sz=self.getSize()
	    szx=sz[0]
	    if szx>4:
		szx=4
	    self.setSize((szx, szx))

	self.buttonRotateIndividually.set_active(indiv)

    def setLongpress(self, lp):
	self.buttonRequireLongpress.set_active(lp)

    def doConfig(self, icon):
	aps=apps.scan()

	lst=[aps[x]['name'] for x in aps]
	lst.sort()

	dialog=gtk.Dialog('App select', None,
	    gtk.DIALOG_DESTROY_WITH_PARENT, buttons=())

	selector=hildon.TouchSelectorEntry(text=True)
	selector.set_column_selection_mode(
	    hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)

	dialog.vbox.pack_start(selector, True, True, 0)
	dialog.set_size_request(0,900)
	dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
	dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)

	selector.append_text('None')

	idx=0
	cnt=1
	for app in lst:
	    if app==None:
		continue
	    selector.append_text(app)
	    if icon.name!=None and aps[icon.name]['name']==app:
		idx=cnt
	    cnt+=1

	selector.set_active(0, idx)

	dialog.show_all()

	app=None

	r=dialog.run()

	if r==gtk.RESPONSE_OK:
	    idx2=selector.get_active(0)
	    if idx2<1:
		app=None
	    else:
		cur=lst[idx2-1]
		for i in aps:
		    if aps[i]['name']==cur:
			app=aps[i]
			break
	    if app!=None:
		app['icon2']=getIcon(app['icon'], self.config.getIconSize())
	    else:
		app={
		    'id':	None,
		    'icon2':	None,
		    }
	    icon.setApp(app)

	dialog.destroy()

    def getData(self):
	szx=0
	szy=0
	for but in self.butsSizeX:
	    szx+=1
	    if but.get_active()==True:
		break

	for but in self.butsSizeY:
	    szy+=1
	    if but.get_active()==True:
		break

	if self.getIndiv():
	    sz=(szx, szy)
	else:
	    sz=(szx, szx)

	wapps={}

	for x in xrange(sz[0]):
	    for y in xrange(sz[1]):
		ico=self.igw.get(x,y)
		k=(x,y)
		wapps[k]=ico.name

	indiv=self.buttonRotateIndividually.get_active()
	lp=self.buttonRequireLongpress.get_active()

	ret={
	    'size':	    sz,
	    'apps':	    wapps,
	    'indiv':	    indiv,
	    'longpress':    lp,
	    }

	return(ret)

if __name__=="__main__":
    win=WinConfig()
    win.connect('delete-event', gtk.main_quit)

    win.show_all()
    gtk.main()



# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

