#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import os
import pickle

version = "0.4"

try:
    from glib import get_user_config_dir
except:
    def get_user_config_dir():
	home=os.environ['HOME']
	if home=='':
	    home="/home/user"
	cfg="%s/.config" % (home)

	return(cfg)

def ensure_dir():
    dir0=get_user_config_dir()
    dir=dir0+'/drlaunch'
    if not os.path.exists(dir):
	os.mkdir(dir)
    if not os.path.isdir(dir):
	raise Exception('Failed to ensure directory' + dir)

    return(dir)

def get_config_fn():
    dir=ensure_dir()
    ret=dir + '/config'

    return(ret)

class Config:
    def __init__(self, id):
	self.id=id

	self.size = (2,2)
	self.iconsize = 64
	self.iconspace = 42
	self.apps=None
	self.indiv=False
	self.longpress=True

	self.maxsz=(4,4)

    def setSize(self, sz):
	self.size=sz

    def getSize(self):
	return(self.size)

    def getMaxSize(self):
	return(self.maxsz)

    def getIconSize(self):
	return(self.iconsize)

    def setIndiv(self, indiv):
	self.indiv=indiv

    def getIndiv(self):
	return(self.indiv)

    def setLongpress(self, lp):
	self.longpress=lp

    def getLongpress(self):
	return(self.longpress)

    def setApps(self, aps):
	""" apps is a dictionary of (x,y)=>appname """
	self.apps=aps

    def getApps(self):
	if self.apps==None:
	    tmp={
		(0,0):  'rtcom-call-ui',
		(0,1):  'rtcom-messaging-ui',
		(1,0):  'browser',
		(1,1):  'osso-addressbook',
		}
	    self.setApps(tmp)

	return(self.apps)

    def save(self):
	self.check_init()

	dt=self.load_all()

	if dt==None:
	    dt={
		'version':  3,
		'data':	{},
		}

	dt['data'][self.id]={
	    'size':	    self.getSize(),
	    'apps':	    self.getApps(),
	    'indiv':	    self.getIndiv(),
	    'longpress':    self.getLongpress(),
	    }

	fn=get_config_fn()

	st=pickle.dumps(dt)
	f=file(fn, 'w')
	f.write(st)
	f.close()

    def parse_v1(self, dt0):
	""" Convert a v1 config to v2 """
	ret={
	    'version':	    2,
	    'data':	    {},
	    }

	ret['data'][self.id]={
	    'size':	    dt0['size'],
	    'apps':	    dt0['apps'],
	    }

	return(ret)

    def parse_v2(self, dt):
	# Perhaps copy dt?

	dt['version']=3

	for i in dt['data']:
	    dt['data'][i]['indiv']=False
	    dt['data'][i]['size']=(dt['data'][i]['size'], dt['data'][i]['size'])
	    dt['data'][i]['longpress']=True

	return(dt)

    def load_all(self):
	fn=get_config_fn()

	try:
	    f=file(fn, 'r')
	    st=f.read()
	    f.close()
	    ret=pickle.loads(st)

	    if ret==None:
		ret=None
	    else:
		if ret['version']==1:
		    ret=parse_v1(ret)

		if ret['version']==2:
		    ret=parse_v2(ret)
	except:
	    ret=None

	return(ret)

    def load(self):
	self.check_init()

	fn=get_config_fn()

	dt0=self.load_all()

	if dt0==None or not dt0['data'].has_key(self.id):
	    return

	dt=dt0['data'][self.id]

	self.setSize(dt['size'])
	self.setApps(dt['apps'])
	self.setIndiv(dt['indiv'])
	self.setLongpress(dt['longpress'])

    def check_init(self):
	if self.id==None:
	    import sys

	    print "config.init() not done"
	    sys.exit(1)

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

