#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import gtk
import gobject
import hildon
from hildondesktop import *
from gtk import gdk
from math import pi
import cairo
import time

from portrait import FremantleRotation
import launcher
from xdg.IconTheme import getIconPath


#import config
import apps

def getIcon(name, iconsize):
    ico=getIconPath(name, iconsize)
    ret=gtk.gdk.pixbuf_new_from_file_at_size(ico, iconsize, iconsize)

    return(ret)

class Icon(gobject.GObject):
    def __init__(self, isconfig, config):
	self.__gobject_init__()

	self.isconfig=isconfig
	self.config=config

	self.name=None
	self.icon=None
	self.lastpress=0
	self.ispressed=False

	self.x=0
	self.y=0

	self.presstime=0.25

	self.window=None

	self.clickcount=0

    def timePressed(self):
	""" return how much time a button is pressed """
	dt=time.time() - self.lastpress

	return(dt)

    def setApp(self, dt):
	if dt==None:
	    self.name=None
	    self.icon=None
	else:
	    self.name=dt['id']
	    self.icon=dt['icon2']
	self.invalidate()

    def getSize(self):
	return(self.config.iconsize+self.config.iconspace)

    def draw(self, cr, x, y, mode):
	self.x=x
	self.y=y

	if self.icon==None and not self.isconfig:
	    return

	cr.save()
	cr.set_source_rgba(0.1, 0.1, 0.1, 1)
	cr.set_line_width(5)

	#if self.ispressed:
	if self.timePressed() <= self.presstime or self.ispressed:
	    t=1.0 * min(self.timePressed(), self.presstime) / self.presstime
	    g=0.3+0.5*t
	    b=0.3+0.7*t
	    cr.set_source_rgba(0, g, b, 0.7)
	else:
	    cr.set_source_rgba(0.3, 0.3, 0.3, 0.7)

	x3=x + (self.config.iconspace/6)
	y3=y + (self.config.iconspace/6)

	r=10	# Radius
	w=self.config.iconsize+(self.config.iconspace*2/3)

	cr.move_to(x3+r, y3)
	cr.arc(x3+w-r,  y3+r,   r,	    pi*1.5, pi*2)
	cr.arc(x3+w-r,  y3+w-r, r,	    0,	    pi*0.5)
	cr.arc(x3+r,    y3+w-r, r,	    pi*0.5, pi)
	cr.arc(x3+r,    y3+r,   r,	    pi,	    pi*1.5)

	cr.stroke_preserve()
	cr.fill()
	cr.clip()
	cr.paint()
	cr.restore()

	if self.icon==None:
	    return

	icon=self.icon

	if mode=='l':
	    icon2=icon
	else:
	    icon2=icon.rotate_simple(gdk.PIXBUF_ROTATE_COUNTERCLOCKWISE)

	cr.save()
	x3=x + (self.config.iconspace/2)
	y3=y + (self.config.iconspace/2)
	cr.set_source_pixbuf(icon2, x3, y3)
	cr.paint()
	cr.restore()

	return(False)

    def timerPressed(self):
#	if not self.ispressed:
#	    return(False)

	self.invalidate()

	if self.timePressed()>self.presstime:
	    ret=False
	else:
	    ret=True

	return(ret)

    def doPress(self):
	# Double-time: time for pressed and time for not-pressed
	if time.time() - self.lastpress > self.presstime*2:
	    self.clickcount=0

	self.lastpress=time.time()
	self.ispressed=True
	gobject.timeout_add(20, self.timerPressed)

    def doRelease(self):
	dt=time.time() - self.lastpress
	self.ispressed=False
	self.invalidate()
	if dt<=self.presstime:
	    self.clickcount+=1
	    if self.clickcount==1:
		self.emit('click')
	    elif self.clickcount==2:
		self.emit('double-click')
	    if self.clickcount==3:
		self.emit('tripple-click')
		self.clickcount=0
	elif dt>self.presstime and dt<2:
	    self.emit('long-press')

    def doCancel(self):
	self.ispressed=False

    def invalidate(self, window=None):
	if window==None:
	    window=self.window
	else:
	    self.window=window
	
	if window==None:
	    return

	w=self.config.iconsize + self.config.iconspace
	rect=gdk.Rectangle(self.x, self.y, w, w)
	gdk.Window.invalidate_rect(window, rect, True)

gobject.type_register(Icon)
signals=['click', 'double-click', 'tripple-click', 'long-press']
for s in signals:
    gobject.signal_new(s, Icon, gobject.SIGNAL_RUN_FIRST,
	gobject.TYPE_NONE, ())

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

