#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import gtk
import gobject
import hildon
import time

from hildon import StackableWindow
#from portrait import FremantleRotation
#from xdg.IconTheme import getIconPath

import config
import apps
from icon import Icon, getIcon
from icongrid import IconGridWidget

class WinConfig(StackableWindow):
    def __init__(self, *args):
	StackableWindow.__init__(self)

	self.setupUi()

    def setupUi(self):
	self.igw=IconGridWidget(True)
#	self.igw.setSize(config.getSize())

	hbox=gtk.HBox()
	self.add(hbox)

	# Add the icongrid
	hbox.add(self.igw)

	# Now go for the right side
	al=gtk.Alignment(yscale=0)
	hbox.add(al)

	vbox=gtk.VBox()
#	hbox.add(vbox)
	al.add(vbox)

	vbox.add(gtk.Label('Grid size:'))

	self.butsSize=[]
	for i in xrange(4):
	    but=gtk.ToggleButton("%sx%s" % (i+1,i+1))
	    but.set_size_request(160, 90)
	    self.butsSize.append(but)
	    but.connect('toggled', self.slotButtonSize, i)

	hbox2=gtk.HBox()
	vbox.add(hbox2)
	hbox2.add(self.butsSize[0])
	hbox2.add(self.butsSize[1])
	hbox2=gtk.HBox()
	vbox.add(hbox2)
	hbox2.add(self.butsSize[2])
	hbox2.add(self.butsSize[3])

	self.igw.connect('long-press', self.slotLongpress)

	self.ignore_toggle=False

	self.setSize(config.getSize())

    def slotLongpress(self, sender, icon):
	self.doConfig(icon)

    def slotButtonSize(self, sender, id):
	self.setSize(id+1)
	
    def setSize(self, sz):
	if self.ignore_toggle:
	    return

	self.ignore_toggle=True

	id=sz-1

	for i in xrange(4):
	    but=self.butsSize[i]
	    but.set_active(i==id)

	self.ignore_toggle=False

	self.igw.setSize(sz)

	self.igw.queue_draw()


    def doConfig(self, icon):
	aps=apps.scan()

	lst=[aps[x]['name'] for x in aps]
	lst.sort()

	dialog=gtk.Dialog('App select', None,
	    gtk.DIALOG_DESTROY_WITH_PARENT, buttons=())

	selector=hildon.TouchSelectorEntry(text=True)
	selector.set_column_selection_mode(
	    hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)

	dialog.vbox.pack_start(selector, True, True, 0)
	dialog.set_size_request(0,900)
	dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
	dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)

	selector.append_text('None')

	idx=0
	cnt=1
	for app in lst:
	    if app==None:
		continue
	    selector.append_text(app)
	    if icon.name!=None and aps[icon.name]['name']==app:
		idx=cnt
	    cnt+=1

	selector.set_active(0, idx)

	dialog.show_all()

	app=None

	r=dialog.run()

	if r==gtk.RESPONSE_OK:
	    cur=selector.get_current_text()
	    if cur=='None':
		app=None
	    else:
		for i in aps:
		    if aps[i]['name']==cur:
			app=aps[i]
			break
	    if app!=None:
		app['icon2']=getIcon(app['icon'])
	    else:
		app={
		    'id':	None,
		    'icon2':	None,
		    }
	    icon.setApp(app)

	dialog.destroy()

    def getData(self):
	sz=0
	for but in self.butsSize:
	    sz+=1
	    if but.get_active()==True:
		break

	wapps={}

	for x in xrange(sz):
	    for y in xrange(sz):
		ico=self.igw.get(x,y)
		k=(x,y)
		wapps[k]=ico.name

	ret={
	    'size':	sz,
	    'apps':	wapps
	    }

	return(ret)

if __name__=="__main__":
    win=WinConfig()
    win.connect('delete-event', gtk.main_quit)

    win.show_all()
    gtk.main()



# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

