#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

# HACK
# Add the current module's directory to sys.path to bypass
# problems when running as widget.
# Restore the path at the end of the imports
import sys
import os

orig_path=sys.path[:]
tmp_path=os.path.dirname( os.path.realpath( __file__ ) )
sys.path.append(tmp_path)

# End of hack

import gtk
import gobject
import hildon
from hildondesktop import *
from gtk import gdk
from math import pi
import cairo
import time

from portrait import FremantleRotation
import launcher
from xdg.IconTheme import getIconPath
from win_config import WinConfig

import config
import apps
from icon import Icon
from icongrid import IconGrid

# Restore path
sys.path=orig_path

# IconGrid must be before HomePluginItem for its connect()
# and do_button_*() to override those of HomePluginItem
class DrlaunchPlugin(IconGrid, HomePluginItem, FremantleRotation):
    def __init__(self):
	IconGrid.__init__(self)
	HomePluginItem.__init__(self)
	FremantleRotation.__init__(self, 'DrlaunchPlugin')

	launcher.init()
	config.load()
	self.setSize(config.getSize())
	self.reloadIcons()

	self.set_settings(True)
	self.connect('show-settings', self.slot_show_settings)
	self.connect('long-press', self.signalLongpress)

    def do_realize(self):
	screen=self.get_screen()
	self.set_colormap(screen.get_rgba_colormap())
	self.set_app_paintable(True)

	HomePluginItem.do_realize(self)

    def on_orientation_changed(self, orientation):
	o=orientation[0]
	self.setMode(o)
#	self.queue_draw()

    def do_expose_event(self, event):
	IconGrid.do_expose_event(self, event)
	HomePluginItem.do_expose_event(self, event)

    def slot_show_settings(self, dt):
	s=WinConfig()
	s.show_all()
	s.connect('destroy', self.slotConfigDestroy)

    def slotConfigDestroy(self, sender):
	dt=sender.getData()
	config.setSize(dt['size'])
	config.setApps(dt['apps'])
	config.save()
	
	# Resize widget
	self.setSize(dt['size'])
	self.reloadIcons()

#	self.queue_draw()

    def signalLongpress(self, sender, icon):
	if icon.name!=None and icon.name!='':
	    launcher.launch(icon.name)

    def resize(self):
	w=(self.size * config.iconsize) + \
	    (self.size * config.iconspace)
	self.set_size_request(w, w)

    def setSize(self, size):
	IconGrid.setSize(self, size)
	self.resize()

hd_plugin_type = DrlaunchPlugin

if __name__=="__main__":
    gobject.type_register(hd_plugin_type)
    obj=gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()



# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

