#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import os
import pickle

version = "0.1"

try:
    from glib import get_user_config_dir
except:
    def get_user_config_dir():
	home=os.environ['HOME']
	if home=='':
	    home="/home/user"
	cfg="%s/.config" % (home)

	return(cfg)

size = 2
iconsize = 64
iconspace = 42
apps=None

def setSize(sz):
    global size

    size=sz

def getSize():
    global size

    return(size)

def setApps(aps):
    """ apps is a dictionary of (x,y)=>appname """
    global apps

    apps=aps

def getApps():
    global apps

    if apps==None:
	tmp={
	    (0,0):  'rtcom-call-ui',
	    (0,1):  'rtcom-messaging-ui',
	    (1,0):  'browser',
	    (1,1):  'osso-addressbook',
	    }
	setApps(tmp)

    return(apps)

def ensure_dir():
    dir0=get_user_config_dir()
    dir=dir0+'/drlaunch'
    if not os.path.exists(dir):
	os.mkdir(dir)
    if not os.path.isdir(dir):
	raise Exception('Failed to ensure directory' + dir)

    return(dir)

def get_config_fn():
    dir=ensure_dir()
    ret=dir + '/config'

    return(ret)

def save():
    fn=get_config_fn()

    dt={
	'version':  1,
	'size':	    getSize(),
	'apps':	    getApps()
	}

    st=pickle.dumps(dt)
    f=file(fn, 'w')
    f.write(st)
    f.close()

def load():
    fn=get_config_fn()

    try:
	f=file(fn, 'r')
	st=f.read()
	f.close()
	dt=pickle.loads(st)
    except:
	return

    setSize(dt['size'])
    setApps(dt['apps'])

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

