#include "drinkcounter.h"
#include "ui_drinkcounter.h"
#include "settings.h"
#include "diagram.h"
#include "newdrink.h"
#include "changeuser.h"

#include <string>
#include <sstream>
#include <QPainter>
#include <fstream>
#include <string>
#include <QMessageBox>
#include <QDesktopServices>
#include <QUrl>
#include <QPropertyAnimation>
#include <QSequentialAnimationGroup>
#include <QAbstractScrollArea>
#include <QScrollArea>
#include <QScrollBar>



using namespace std;

const int button_width=140;
const int button_height=70;
const int button_gap=10;
const int CALC_INTERVAL=60000; //msecs

#define THE_ANSWER 42

int yOffset=25;

DrinkCounter::DrinkCounter(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::DrinkCounter)
{
    QPixmap *pix;
    QPixmap *pix2;

    ui->setupUi(this);

    actualPage=1;
    hasChanged=false;

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    loadProgramSettings();
    loadPersonalSettings();

    alc = new Alcohol(&drinks, &drinkDefs, &timeLine, &sett);

    ui->scrollArea->setProperty("FingerScrollable", true);
    //ui->sarDrinks->setProperty("FingerScrollable", true);

    dragNdropTimer = new QTimer(this);
    connect(dragNdropTimer, SIGNAL(timeout()), this, SLOT(dragNdropTimer_timeout()));

    dropDelayTimer = new QTimer(this);
    connect(dropDelayTimer, SIGNAL(timeout()), this, SLOT(dropDelayTimer_timeout()));

    slideTimer = new QTimer(this);
    connect(slideTimer, SIGNAL(timeout()), this, SLOT(slideTimer_timeout()));

    calcTimer = new QTimer(this);
    connect(calcTimer, SIGNAL(timeout()), this, SLOT(calcTimer_timeout()));

    soundTimer = new QTimer(this);
    connect(soundTimer, SIGNAL(timeout()), this, SLOT(soundTimer_timeout()));

    trashTimer = new QTimer(this);
    connect(trashTimer, SIGNAL(timeout()), this, SLOT(trashTimer_timeout()));

    startTimer = new QTimer(this);
    connect(startTimer, SIGNAL(timeout()), this, SLOT(startTimer_timeout()));

    uiChangeDelayTimer = new QTimer(this);
    connect(uiChangeDelayTimer, SIGNAL(timeout()), this, SLOT(uiChangeDelay_timeout()));

    drinkButtons = new QButtonGroup;
    connect(drinkButtons, SIGNAL(buttonPressed(int)), this, SLOT(btnPressed(int)));
    connect(drinkButtons, SIGNAL(buttonReleased(int)), this, SLOT(btnReleased(int)));

    drinkButtonsDone = new QButtonGroup;
    connect(drinkButtonsDone, SIGNAL(buttonClicked(int)), this, SLOT(btnDoneClicked(int)));

    btnNextPage = new QPushButton(this);
    btnNextPage->setVisible(false);
    btnNextPage->setFlat(true);
    //btnNextPage->setText(">>");
    pix = new QPixmap(":/images/arrow_right.png");
    btnNextPage->setIcon(*pix);
    btnNextPage->setIconSize(QSize(button_height, button_height));
    delete pix;
    connect(btnNextPage, SIGNAL(clicked()), this, SLOT(btnNextPage_clicked()));

    btnPrevPage = new QPushButton(this);
    btnPrevPage->setFlat(true);
    btnPrevPage->setVisible(false);
    //btnPrevPage->setText("<<");
    pix = new QPixmap(":/images/arrow_left.png");
    btnPrevPage->setIcon(*pix);
    btnPrevPage->setIconSize(QSize(button_height, button_height));
    delete pix;
    connect(btnPrevPage, SIGNAL(clicked()), this, SLOT(btnPrevPage_clicked()));

    trashLabel = new QLabel(this);
    editLabel = new QLabel(this);
    trashLabel->setGeometry(this->width(), 10, button_width, button_width);
    editLabel->setGeometry(this->width(), button_width+15, button_width, button_width);
    pix = new QPixmap(":/images/trash.png");
    pix2 = new QPixmap(pix->scaledToWidth(button_width, Qt::FastTransformation));
    trashLabel->setPixmap(*pix2);
    delete pix; pix=0;
    delete pix2; pix2=0;

    pix = new QPixmap(":/images/edit.png");
    pix2 = new QPixmap(pix->scaledToWidth(button_width, Qt::FastTransformation));
    editLabel->setPixmap(*pix2);
    delete pix; pix=0;
    delete pix2; pix2=0;
    trashLabel->show();
    editLabel->show();



    startTimer->start(500);

}

DrinkCounter::~DrinkCounter() {
    clearUserSettings();
    clearSettings();

    saveProgramSettings();
    savePersonalSettings();
    saveDrinks();
    saveDefinitions();

    for(int i=0; i<drinkButtons->buttons().count(); i++) {
        delete drinkButtons->button(i);
    }
    delete drinkButtons;

    for(int i=0; i<drinks.count(); i++) {
        delete drinks.at(i).btn;
    }

    delete trashLabel; trashLabel=0;
    delete editLabel; editLabel=0;

    delete ui;
}

void DrinkCounter::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void DrinkCounter::resizeEvent(QResizeEvent* event) {
    if(startTimer->isActive())
        return;
    uiChangeDelayTimer->start(10);
}

std::string intToString(int val) {
    std::string str;
    std::ostringstream ss;
    ss << val;
    str=ss.str();
    return str;
}

int DrinkCounter::getMaxDrinksInRow() {
    int xMax=0;
    int xPos=0;
    while(xMax+button_width < ui->btnNewDrink->geometry().x()) {
        xMax+=(button_width+button_gap);
        xPos++;
    }

    if(xPos==0)
        return 1;
    else
        return xPos;
}

int DrinkCounter::getXPos(int btnNr) {
    return (button_width+button_gap)*(btnNr%getMaxDrinksInRow()) + button_gap;
}

int DrinkCounter::getYPos(int btnNr) {
    return (btnNr/getMaxDrinksInRow())*(button_height + button_gap) + button_gap;
}

int DrinkCounter::getMaxDrinksPerPage() {
    int yMax=0;
    int yPos=0;
    while(yMax+button_height < (ui->boxHistory->geometry().y()+20) ) {
        yMax+=(button_height+button_gap);
        yPos++;
    }

    if(yPos==0)
        return 1;
    else
        return (yPos*getMaxDrinksInRow()-2);
}

void DrinkCounter::setToStartPos(QPushButton *btn, int btnNr, bool animation=false) {
    int xPos=getXPos(btnNr-getMaxDrinksPerPage()*(actualPage-1));
    int yPos=getYPos(btnNr-getMaxDrinksPerPage()*(actualPage-1));

    if(btnNr < getMaxDrinksPerPage()*actualPage && btnNr >= getMaxDrinksPerPage()*(actualPage-1)) {
        btn->setVisible(true);
    }
    else {
        btn->setVisible(false);
        return;
    }

    if(animation) {
        slideTo(btn, xPos, yPos );
        btn->setIconSize(QSize(button_width, button_height));
    }
    else {
        btn->setGeometry(xPos, yPos, button_width, button_height);
        QPropertyAnimation *anim = new QPropertyAnimation(btn, "iconSize");
        anim->setDuration(500);
        anim->setEasingCurve(QEasingCurve::InOutQuad);
        anim->setStartValue(QSize(0, 0));
        anim->setEndValue(QSize(button_width, button_height));
        anim->start();
        runningAnimations.append(anim);
        //connect(anim, SIGNAL(finished()), this, SLOT(animationCleanup()));
    }

}

void DrinkCounter::slideTo(QPushButton *but, int xTo, int yTo) {
    const int slide_time=40;
    int xFrom=but->x();
    int yFrom=but->y();

    int lenX=xTo-xFrom;
    int lenY=yTo-yFrom;

    xPos=xFrom;
    yPos=yFrom;
    animatedButton=but;

    //X calc
    stepsX[0]=lenX/32;
    stepsX[1]=lenX/16;
    stepsX[2]=lenX/8;
    stepsX[3]=lenX/4;
    stepsX[4]=stepsX[3];
    stepsX[5]=stepsX[2];
    stepsX[6]=stepsX[1];
    stepsX[7]=stepsX[0];
    stepsX[8]=0;

    int sum=0;
    for(int i=0; i<8; i++)
            sum+=stepsX[i];

    //integer division fehler offset addieren
    stepsX[4]+=lenX-sum;

    //Y calc
    stepsY[0]=lenY/32;
    stepsY[1]=lenY/16;
    stepsY[2]=lenY/8;
    stepsY[3]=lenY/4;
    stepsY[4]=stepsY[3];
    stepsY[5]=stepsY[2];
    stepsY[6]=stepsY[1];
    stepsY[7]=stepsY[0];
    stepsY[8]=0;

    sum=0;
    for(int i=0; i<8; i++)
            sum+=stepsY[i];

    stepsY[4]+=lenY-sum;

    slideTimer->start(slide_time);
}

void drawText(QPixmap *pix, QString line1="", QString line2="") {
    QPainter painter(pix);
    const int shad_off=2;
    const int line_off=40;
    int yPos=20;

    QPen pen;
    pen.setWidth(4);
    pen.setColor(Qt::black);

    painter.setPen(pen);
    painter.drawText(shad_off, yPos + shad_off, line1);
    painter.drawText(shad_off, yPos + shad_off + line_off, line2);

    pen.setColor(Qt::white);
    painter.setPen(pen);
    painter.drawText(0, yPos, line1);
    painter.drawText(0, yPos + line_off, line2);

    painter.end();
}

void DrinkCounter::addDrink(int btnNr, QTime timeQ, time_t unixTime, bool addsPermill=true, bool haveToPay=true, float bill=0) {
    if (btnNr>=drinkDefs.count())
        return;

    QPixmap *pix2;

    if(btnNr==-1)
        pix2 = new QPixmap(":/images/money.png");
    else
        pix2 = new QPixmap(drinkDefs.at(btnNr).filename);

    QPixmap *pix = new QPixmap(pix2->scaledToWidth(button_width, Qt::FastTransformation));
    drink dr;
    int pos=drinks.count();

    dr.type = btnNr;
    dr.time = timeQ;
    dr.unixTime = unixTime;
    if(btnNr==-1) {
        dr.additivePermill=0;
        dr.bill=bill;
    }
    else {
        dr.additivePermill = alc->calcAlc(btnNr);
        dr.bill=0;
    }
    dr.haveToPay=haveToPay;
    dr.addsPermill=addsPermill;

    QString txt;
    if(btnNr==-1) {
        txt = "Bill: " + QString::number(bill);
    }
    else
        txt = drinkDefs.at(btnNr).text;

    QString timeStr = dr.time.toString("hh:mm");

    drawText(pix, txt, timeStr);

    dr.btn = new QPushButton(ui->drinksDone);

    dr.btn->setGeometry((button_width+button_gap)*drinks.count(), button_gap, button_width, button_height);
    //dr.btn->setIconSize(QSize(button_width, button_height));
    dr.btn->setIconSize(QSize(0, 0));
    dr.btn->setIcon(*pix);
    dr.btn->show();

    ui->drinksDone->setMinimumWidth( (drinks.count()+2) * (button_width+button_gap) );

    drinks.append(dr);

    drinkButtonsDone->addButton(dr.btn, pos);

    QPropertyAnimation *anim = new QPropertyAnimation(dr.btn, "iconSize");
    anim->setDuration(1000);
    anim->setEasingCurve(QEasingCurve::InOutQuad);
    anim->setStartValue(QSize(0,0));
    anim->setEndValue(QSize(button_width,button_height));
    anim->start();
    runningAnimations.append(anim);

    hasChanged=true;

    delete pix;pix=0;
    delete pix2;pix2=0;
}

void DrinkCounter::addDef(drinkDefinition def)
{
    QPixmap *pix2 = new QPixmap(def.filename);
    QPixmap *pix = new QPixmap(pix2->scaledToWidth(button_width, Qt::FastTransformation));

    QPushButton *btn = new QPushButton(this);


    int pos=drinkDefs.count();

    drawText(pix, def.text);

    btn->setIcon(*pix);
    btn->setIconSize(QSize(0, 0));
    setToStartPos(btn, pos);
    btn->setFlat(true);
    btn->show();

    if(drinkDefs.count()/getMaxDrinksPerPage() >=1 && !startTimer->isActive()) {
        btnNextPage->setVisible(true);
        btnPrevPage->setVisible(true);
    }

    drinkButtons->addButton(btn, pos);
    drinkDefs.append(def);

    hasChanged=true;

    delete pix; pix=0;
    delete pix2;pix2=0;
}

void DrinkCounter::deleteDefinition(int btnNr)
{
    QAbstractButton *but = drinkButtons->button(btnNr);
    QMessageBox msgBox;
#ifdef Q_WS_MAEMO_5
    msgBox.setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    msgBox.setWindowTitle("Delete drink");
    msgBox.setText("This will delete you history.\nAre you sure to remove this drink and begin a new history?");
    msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
    msgBox.setDefaultButton(QMessageBox::No);
    int ret = msgBox.exec();

    switch (ret) {
        case QMessageBox::Yes:
            deleteDrinks();

            drinkButtons->removeButton(but);
            delete but;
            drinkDefs.remove(btnNr);
            for(int i=btnNr+1; i<drinkDefs.count()+1; i++)
                drinkButtons->setId(drinkButtons->button(i), i-1);
            reloadDefinitions();
            break;

        case QMessageBox::No:
            setToStartPos((QPushButton*)drinkButtons->button(btnNr), btnNr);
            break;
    }

}

void DrinkCounter::editDefinition(int btnNr) {
    NewDrink *dr = new NewDrink(this, drinkDefs.at(btnNr).amountMl, drinkDefs.at(btnNr).percentage, drinkDefs.at(btnNr).filename, drinkDefs.at(btnNr).text);
    dr->exec();
    if (dr->isAccepted())
    {
        drinkDefs.replace(btnNr, dr->drDef);
    }
    delete dr; dr=0;
    //setToStartPos((QPushButton*)drinkButtons->button(btnNr), btnNr, false);
    showAlc();
    saveDefinitions();
    reloadDefinitions();
}

void DrinkCounter::showAlc() {
    alc->calcTimeLine();
    if(alc->getTimeLineCount()<1)
    {
        ui->btnDiagram->setText("0\nper mill");
        return;
    }

    //ui->btnDiagram->setIconSize(QSize(btn_w, btn_h));
    QString txt = QString::number(timeLine.back()) + "\nper mill";
    ui->btnDiagram->setText(txt);
    //ui->btnDiagram->setIcon(QPixmap());

}

void DrinkCounter::animationCleanup() {
    for(int i=0; i<runningAnimations.size(); i++) {
        if((*runningAnimations.at(i)).state() == QPropertyAnimation::Stopped) {
            //disconnect(runningAnimations.at(i));
            delete runningAnimations[i];
            runningAnimations[i]=0;
            runningAnimations.remove(i);
        }
    }
}



//##### Timers

void DrinkCounter::dragNdropTimer_timeout() {
    posX = QCursor::pos().x() - this->geometry().x();// - ui->wdgDrinks->geometry().x() - ui->sarDrinks->geometry().x();
    posY = QCursor::pos().y() - this->geometry().y() - yOffset;// - ui->wdgDrinks->geometry().y() - ui->sarDrinks->geometry().y();

    drinkButtons->button(activeButton)->setGeometry(posX-button_width/2, posY-button_height/2, button_width, button_height);
}

void DrinkCounter::dropDelayTimer_timeout()
{
    static int timeouts=0;
    int btnNr = activeButton;

    if(timeouts>=4)
    {
        dragNdropTimer->stop();
        if(drinkButtons->button(btnNr)->y() >= ui->boxHistory->y()) {
            addDrink(btnNr, QTime::currentTime(), time(NULL));
            setToStartPos((QPushButton*)drinkButtons->button(btnNr), btnNr, true);
        }
        else if( (drinkButtons->button(btnNr)->x() >= trashLabel->x() ) && ( drinkButtons->button(btnNr)->y() <= trashLabel->y()+trashLabel->height() ) )
        {
            deleteDefinition(btnNr);
        }
        else if( (drinkButtons->button(btnNr)->x() >= editLabel->x() ) && ( drinkButtons->button(btnNr)->y() <= editLabel->y()+editLabel->height() ) )
        {
            editDefinition(btnNr);
        }
        else
            setToStartPos((QPushButton*)drinkButtons->button(btnNr), btnNr, true);

        slideTrashIn=false;
        trashTimer->start();
        dropDelayTimer->stop();
        timeouts=0;
        //if(yOffset<50)
        //    yOffset+=10;
        showAlc();
    }
    else
        timeouts++;

}

void DrinkCounter::calcTimer_timeout() {
    if(hasChanged) {
        clearUserSettings();
        clearSettings();
        saveProgramSettings();
        savePersonalSettings();
        saveDrinks();
        saveDefinitions();
        hasChanged=false;
    }
    showAlc();
    calcTimer->setInterval(CALC_INTERVAL);
    animationCleanup();
}

void DrinkCounter::trashTimer_timeout()
{
    int step=10;

    trashTimer->setInterval(10);

    if(slideTrashIn)
    {
        if(trashLabel->x() <= this->width()-button_width)
            trashTimer->stop();
        else {
            trashLabel->setGeometry(trashLabel->x()-step, trashLabel->y(), trashLabel->width(), trashLabel->height());
            editLabel->setGeometry(editLabel->x()-step, editLabel->y(), editLabel->width(), editLabel->height());
            trashLabel->show();
            editLabel->show();
        }

    }
    else
    {
        if(trashLabel->x() > this->width()) {
            trashTimer->stop();
            trashLabel->hide();
            editLabel->hide();
        }
        else {
            trashLabel->setGeometry(trashLabel->x()+step, trashLabel->y(), trashLabel->width(), trashLabel->height());
            editLabel->setGeometry(editLabel->x()+step, editLabel->y(), editLabel->width(), editLabel->height());
        }
    }
}

void DrinkCounter::slideTimer_timeout() {
        static int counter=0;

        xPos+=stepsX[counter];
        yPos+=stepsY[counter];

        animatedButton->setGeometry(xPos, yPos, animatedButton->width(), animatedButton->height());
        counter++;

        if(counter>8) {
            counter=0;
            slideTimer->stop();
        }
}

void DrinkCounter::startTimer_timeout() {
    loadDefinitions();
    loadDrinks();

    calcTimer->start(CALC_INTERVAL);
    showAlc();
    uiChangeDelayTimer->start(1);

    startTimer->stop();
}

void DrinkCounter::soundTimer_timeout() {
    //music->pause();
    soundTimer->stop();
}

void DrinkCounter::uiChangeDelay_timeout() {
    reloadDefinitions();

    btnNextPage->setGeometry(getXPos(getMaxDrinksPerPage()+1), getYPos(getMaxDrinksPerPage()+1)+20, button_width, button_height);
    btnPrevPage->setGeometry(getXPos(getMaxDrinksPerPage()), getYPos(getMaxDrinksPerPage())+20, button_width, button_height);

    uiChangeDelayTimer->stop();
}

// ##### Button slots

void DrinkCounter::on_btnDiagram_clicked() {
    alc->calcTimeLine();
    showAlc();
    Diagram *dia = new Diagram(this, alc);
    #ifdef Q_WS_MAEMO_5
        dia->setAttribute(Qt::WA_Maemo5StackedWindow);
        dia->setWindowFlags(dia->windowFlags() | Qt::Window);
    #endif
    dia->show();
}

void DrinkCounter::on_actionSettings_triggered()
{
    settings *set = new settings(this, sett);
    set->exec();
    sett = set->sett;
    delete set;set=0;
    calcTimer->stop();
    calcTimer->start(1000);
}

void DrinkCounter::on_actionAbout_triggered()
{
    QMessageBox msgBox;
#ifdef Q_WS_MAEMO_5
    msgBox.setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    QString str;
    const QUrl url("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=FC8VEACGJFN9J&lc=AT&item_name=Andreas%20Weidlinger&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted");



    msgBox.addButton("Donate", QMessageBox::YesRole);
    msgBox.addButton("Done", QMessageBox::NoRole);

    str= "This Software helps you to estimate your alcohol level, but don't trust this value!\n";
    str+="It also lets you remember how many drinks you had.\n\n";
    str+="Author: Andreas Weidlinger (andreas.weidlinger@gmail.com)\n";
    str+="License: GPL\n";
    str+="Written in Qt\n";
    str+="I would be happy if you donate a little, I am student and need the money :)";

    msgBox.setText(str);

    int ret = msgBox.exec();

    switch (ret) {
        case 0:
            QDesktopServices::openUrl(url);
            break;

        case QMessageBox::NoRole:
            break;
    }
}

void DrinkCounter::on_actionDelete_History_triggered() {
    QMessageBox msgBox;
#ifdef Q_WS_MAEMO_5
    msgBox.setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    msgBox.setWindowTitle("New Party?");
    msgBox.setText("Are you sure to begin a new history?");
    msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
    msgBox.setDefaultButton(QMessageBox::No);
    int ret = msgBox.exec();

    switch (ret) {
        case QMessageBox::Yes:
            deleteDrinks();
            calcTimer->stop();
            calcTimer->start(500);
            break;
        case QMessageBox::No:

            break;
    }

}

void DrinkCounter::on_btnMakeBill_clicked()
{
    Bill *bill = new Bill(this, &drinks, &drinkDefs);
    #ifdef Q_WS_MAEMO_5
        bill->setAttribute(Qt::WA_Maemo5StackedWindow);
        //bill->setWindowFlags(bill->windowFlags() | Qt::Window);
    #endif

    bill->exec();

    if(bill->isAccepted())
    {
        addDrink(-1, QTime::currentTime(), time(NULL), false, false, bill->getSum());
    }
    delete bill; bill=0;

}

void DrinkCounter::on_btnNewDrink_clicked()
{
    NewDrink *dr = new NewDrink();
    dr->exec();
    if (dr->isAccepted())
    {
        addDef(dr->drDef);
    }
    delete dr; dr=0;
}

void DrinkCounter::btnPressed(int btnNr)
{
    activeButton=btnNr;

    if(ui->actionEnable_drag_drop->isChecked()) //when dragNdrop enabled, start buttonDragNdrop Timer
    {
        dropDelayTimer->stop();
        dragNdropTimer->start(1);
        slideTrashIn=true;
        trashTimer->start();
    }

}

void DrinkCounter::btnReleased(int btnNr) {
    if(ui->actionEnable_drag_drop->isChecked()) //is dragNdrop enabled?
    {
        activeButton = btnNr;
        dropDelayTimer->start(50);
    }
    else {
        addDrink(btnNr, QTime::currentTime(), time(NULL));
    }

    showAlc();

    //ui->scrollArea->ensureVisible(ui->drinksDone->width(),0,0,0);//scroll max to the right side

    //ui->scrollArea->horizontalScrollBar()->setRange(0, ui->drinksDone->minimumWidth()/2);

    QPropertyAnimation *anim = new QPropertyAnimation(ui->scrollArea->horizontalScrollBar(), "value");
    anim->setDuration(1000);
    anim->setEasingCurve(QEasingCurve::InOutQuad);
    anim->setStartValue(ui->scrollArea->horizontalScrollBar()->value());
    anim->setEndValue(ui->drinksDone->minimumWidth());
    anim->start();
    runningAnimations.append(anim);
}

void DrinkCounter::btnDoneClicked(int btnNr)
{
    QMessageBox msgBox;
#ifdef Q_WS_MAEMO_5
    msgBox.setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    QString str;
    drink dr;
    dr = drinks.at(btnNr);
    bool bill=false;

    if( drinks.at(btnNr).type == -1 )
        bill=true;

    if(bill) {
        str="Do you want to delete this bill?";
    }
    else {
        str="What do you want to do with this drink?";
    }


    msgBox.addButton("Delete", QMessageBox::YesRole);

    if(!bill) {
        if(!drinks.at(btnNr).addsPermill)
        {
            str+="\n-> Another person have drunken it";
            msgBox.addButton("I have drunk it", QMessageBox::ApplyRole);
        }
        else
            msgBox.addButton("Another person drank it", QMessageBox::ApplyRole);

        if(!drinks.at(btnNr).haveToPay)
        {
            str+="\n-> You dont have to pay for that drink";
            msgBox.addButton("I have to pay for it", QMessageBox::AcceptRole);
        }
        else
            msgBox.addButton("I dont have to pay for it", QMessageBox::AcceptRole);
    }


    msgBox.addButton("Abort", QMessageBox::NoRole);

    msgBox.setText(str);

    int ret = msgBox.exec();

    switch (ret) {
        case 0:
            drinkButtonsDone->removeButton(drinks.value(btnNr).btn);
            delete drinks.value(btnNr).btn;
            drinks.remove(btnNr);
            for(int i=btnNr+1; i<drinks.count()+1; i++)
                drinkButtonsDone->setId(drinkButtonsDone->button(i), i-1);
            reloadDrinks();
            calcTimer->stop();
            calcTimer->start(500);
            break;

        case 1:
            dr.addsPermill = !(drinks.at(btnNr).addsPermill);
            drinks.replace(btnNr, dr);
            alc->calcTimeLine();
            showAlc();
            break;

        case 2:
            dr.haveToPay = !(drinks.at(btnNr).haveToPay);
            drinks.replace(btnNr, dr);
            break;

    case QMessageBox::NoRole:
            break;
    }
}

void DrinkCounter::btnNextPage_clicked() {
    if(actualPage <= drinkDefs.count()/getMaxDrinksPerPage()) {
        actualPage++;
        reloadDefinitions();
    }
    animationCleanup();
}

void DrinkCounter::btnPrevPage_clicked() {
    if(actualPage>1) {
        actualPage--;
        reloadDefinitions();
    }
    animationCleanup();
}

//##### fileops

void DrinkCounter::loadDrinks() {
    int drinkType, hour, min;
    time_t unixTime;
    QTime time;
    bool addsPermill, haveToPay;
    float bill;

    QSettings settings("Fssoft", "DrinkCounter" + currentUser);
    int size = settings.beginReadArray("drinks");
    for (int i = 0; i < size; ++i) {
        settings.setArrayIndex(i);
        drinkType = settings.value("drinkType").toInt();
        hour = settings.value("hour").toInt();
        min = settings.value("min").toInt();
        unixTime = settings.value("unixTime").toUInt();
        addsPermill = settings.value("addsPermill").toBool();
        haveToPay = settings.value("haveToPay").toBool();
        bill = settings.value("bill").toFloat();

        time.setHMS(hour, min, 0, 0);
        addDrink(drinkType, time, unixTime, addsPermill, haveToPay, bill);
    }
    settings.endArray();
}

void DrinkCounter::saveDrinks() {
    QSettings settings("Fssoft", "DrinkCounter" + currentUser);
    settings.beginWriteArray("drinks");
    for (int i = 0; i < drinks.size(); ++i) {
        settings.setArrayIndex(i);
        settings.setValue("drinkType", drinks.at(i).type);
        settings.setValue("hour", drinks.at(i).time.hour());
        settings.setValue("min", drinks.at(i).time.minute());
        settings.setValue("unixTime", (unsigned int)drinks.at(i).unixTime);
        settings.setValue("addsPermill", drinks.at(i).addsPermill);
        settings.setValue("haveToPay", drinks.at(i).haveToPay);
        settings.setValue("bill", drinks.at(i).bill);

    }
    settings.endArray();
}

void DrinkCounter::deleteDrinks() {
    for(int i=0; i<drinks.count(); i++)
    {
        delete drinks.at(i).btn;
    }
    drinks.clear();
}

void DrinkCounter::reloadDrinks()
{
    saveDrinks();
    deleteDrinks();
    loadDrinks();
}

void DrinkCounter::loadDefinitions() {
    QSettings settings("Fssoft", "DrinkCounter");
    int size = settings.beginReadArray("drinkDefs");
    for (int i = 0; i < size; ++i) {
        settings.setArrayIndex(i);
        drinkDefinition def;
        def.amountMl = settings.value("amountMl").toInt();
        def.filename = settings.value("filename").toString();
        def.percentage = settings.value("percentage").toInt();
        def.text = settings.value("text").toString();
        def.price = settings.value("price").toFloat();

        addDef(def);
    }
    settings.endArray();
}

void DrinkCounter::saveDefinitions() {
    QSettings settings("Fssoft", "DrinkCounter");
    settings.beginWriteArray("drinkDefs");
    for (int i = 0; i < drinkDefs.size(); ++i) {
        settings.setArrayIndex(i);
        settings.setValue("amountMl", drinkDefs.at(i).amountMl);
        settings.setValue("filename", drinkDefs.at(i).filename);
        settings.setValue("percentage", drinkDefs.at(i).percentage);
        settings.setValue("text", drinkDefs.at(i).text);
        settings.setValue("price", drinkDefs.at(i).price);
    }
    settings.endArray();
}

void DrinkCounter::reloadDefinitions()
{
    QVector<drinkDefinition> tmp=drinkDefs;
    dropDelayTimer->stop();
    dragNdropTimer->stop();

    for(int i=0; i<drinkDefs.count(); i++)
    {
        QAbstractButton *but = drinkButtons->button(i);

        but->hide();
        drinkButtons->removeButton(but);
        delete but;
        //delete drinkButtons->button(i);
        //delete drinkButtons->buttons().at(i);
    }
    drinkDefs.clear();

    for(int i=0; i<tmp.count(); i++)
    {
        addDef(tmp.at(i));
    }
    //loadDefinitions();
}

void DrinkCounter::savePersonalSettings() {
    QSettings settings("Fssoft", "DrinkCounter" + currentUser);

    settings.setValue("bodyAge", sett.bodyAge);
    settings.setValue("bodyHeight", sett.bodyHeight);
    settings.setValue("bodyGender", sett.bodyGenderIsFemale);
    settings.setValue("bodyWeight", sett.bodyWeight);
    settings.setValue("permillePerHour", sett.permillePerHour);
    settings.setValue("driveLimit", sett.driveLimit);
}

void DrinkCounter::loadPersonalSettings() {
    QSettings settings("Fssoft", "DrinkCounter" + currentUser);

    sett.bodyAge = settings.value("bodyAge").toInt();
    sett.bodyGenderIsFemale = settings.value("bodyGender").toBool();
    sett.bodyHeight = settings.value("bodyHeight").toInt();
    sett.bodyWeight = settings.value("bodyWeight").toInt();
    sett.permillePerHour = settings.value("permillePerHour").toDouble();
    sett.driveLimit = settings.value("driveLimit").toDouble();

}

void DrinkCounter::loadProgramSettings() {
    QSettings settings("Fssoft", "DrinkCounter" + currentUser);
    int firstStart;

    currentUser = settings.value("currentUser").toString();
    ui->actionEnable_drag_drop->setChecked( settings.value("dragNdrop").toBool() );
    firstStart = settings.value("firstStart").toInt();

    if(firstStart!=THE_ANSWER)
        ui->actionEnable_drag_drop->setChecked(true);
}

void DrinkCounter::saveProgramSettings() {
    QSettings settings("Fssoft", "DrinkCounter");
    settings.setValue("dragNdrop", ui->actionEnable_drag_drop->isChecked());
    settings.setValue("firstStart", THE_ANSWER);
    settings.setValue("currentUser", currentUser);
}

void DrinkCounter::clearSettings() {
    QSettings settings("Fssoft", "DrinkCounter");
    settings.clear();
}

void DrinkCounter::clearUserSettings() {
    QSettings settings("Fssoft", "DrinkCounter" + currentUser);
    settings.clear();
}

void DrinkCounter::on_actionChange_user_triggered()
{
    QString newUser=currentUser;
    ChangeUser *change = new ChangeUser(this, &newUser);
    #ifdef Q_WS_MAEMO_5
        change->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif


    change->exec();

    checkEasterEgg(newUser);

    if(change->isAccepted)
    {
        if(newUser!=currentUser) {
            clearUserSettings();
            saveDrinks();
            savePersonalSettings();

            currentUser = newUser;

            loadPersonalSettings();
            deleteDrinks();
            loadDrinks();
        }

    }
    delete change; change=0;
}



void DrinkCounter::checkEasterEgg(QString str) {
/*    if(str=="elli") {
        static bool first = true;
        if(first)
            music = Phonon::createPlayer(Phonon::MusicCategory, Phonon::MediaSource("/home/user/sound.mp3"));
        music->play();
        soundTimer->start(20000);
    }*/
}
