#ifndef DRINKCOUNTER_H
#define DRINKCOUNTER_H

#include <QMainWindow>
#include <QTimer>
#include <QPushButton>
#include <QButtonGroup>
#include <QTime>
#include <QSettings>
#include <QLabel>
#include <QPropertyAnimation>
#include "alcohol.h"
#include "bill.h"


/*#include <Phonon/AudioOutput>
#include <Phonon/SeekSlider>
#include <Phonon/MediaObject>
#include <Phonon/VolumeSlider>
#include <Phonon/BackendCapabilities>*/


namespace Ui {
    class DrinkCounter;
}

class DrinkCounter : public QMainWindow {
    Q_OBJECT
public:
    DrinkCounter(QWidget *parent = 0);

    ~DrinkCounter();

protected:
    void changeEvent(QEvent *e);
    void resizeEvent(QResizeEvent* event);
    //void resizeEvent();

private:
    Ui::DrinkCounter *ui;
    QTimer *dragNdropTimer;
    QTimer *dropDelayTimer;
    QTimer *calcTimer;
    QTimer *trashTimer;
    QTimer *slideTimer;
    QTimer *startTimer;
    QTimer *uiChangeDelayTimer;
    QTimer *soundTimer;

    QButtonGroup *drinkButtons;
    QButtonGroup *drinkButtonsDone;
    QLabel *trashLabel;
    QLabel *editLabel;
    QPushButton *animatedButton;
    QPushButton *btnNextPage;
    QPushButton *btnPrevPage;
    QString currentUser;
    int activeButton;
    int actualPage;
    int posX, posY;
    bool slideTrashIn;
    bool hasChanged;
    Alcohol *alc;

    //Phonon::MediaObject *music;

    //animation variables
    int xPos;
    int yPos;
    int stepsX[9];
    int stepsY[9];

    QVector<drink> drinks;
    QVector<drinkDefinition> drinkDefs;
    QVector<float> timeLine;
    QVector<QPropertyAnimation*> runningAnimations;
    settingsStruct sett;

    void addDrink(int btnNr, QTime time, time_t unixTime, bool addsPermill, bool haveToPay, float bill);
    void loadDefinitions();
    void saveDefinitions();
    void reloadDefinitions();
    void deleteDefinition(int btnNr);
    void editDefinition(int btnNr);
    void deleteDrinks();
    void loadDrinks();
    void saveDrinks();
    void reloadDrinks();
    void savePersonalSettings();
    void loadPersonalSettings();
    void loadProgramSettings();
    void saveProgramSettings();
    void clearSettings();
    void clearUserSettings();
    void addDef(drinkDefinition def);
    void checkEasterEgg(QString str);

    void setToStartPos(QPushButton *btn, int btnNr, bool animation);
    void slideTo(QPushButton *but, int xTo, int yTo);
    void showAlc();

    int getMaxDrinksInRow();
    int getXPos(int btnNr);
    int getYPos(int btnNr);
    int getMaxDrinksPerPage();


private slots:
    void on_actionChange_user_triggered();
    void on_btnMakeBill_clicked();
    void on_actionDelete_History_triggered();
    void on_actionAbout_triggered();
    void on_btnNewDrink_clicked();
    void btnPressed(int btnNr);
    void btnReleased(int btnNr);
    void btnDoneClicked(int btnNr);
    void dragNdropTimer_timeout();
    void dropDelayTimer_timeout();
    void calcTimer_timeout();
    void trashTimer_timeout();
    void slideTimer_timeout();
    void startTimer_timeout();
    void soundTimer_timeout();
    void uiChangeDelay_timeout();

    void on_btnDiagram_clicked();
    void btnNextPage_clicked();
    void btnPrevPage_clicked();

    void on_actionSettings_triggered();
    void animationCleanup();
};

#endif
