#include <QFileDialog>
#include "newdrink.h"
#include "ui_newdrink.h"

NewDrink::NewDrink(QWidget *parent, int amountGiven, int percentageGiven, QString filenameGiven, QString textGiven) :
//NewDrink::NewDrink(QWidget *parent, QString fname) :
    QDialog(parent),
    ui(new Ui::NewDrink)
{
    ui->setupUi(this);
    imagePath = QCoreApplication::applicationDirPath() + "/drinkImages";
    accept=false;

    ui->cmbAmount->clear();
    for(int i=0; i<=100; i++) {
        ui->cmbAmount->addItem(QString::number(i*10));
    }

    ui->cmbPercentageHigh->clear();
    for(int i=0; i<80; i++)
    {
        ui->cmbPercentageHigh->addItem(QString::number(i));
    }

    if(filenameGiven=="") { //edit or new drinkdefinition?
        drDef.filename = imagePath + "/white.png";
    }
    else {
        drDef.filename = filenameGiven;
        ui->cmbAmount->setCurrentIndex(amountGiven/10);
        ui->cmbPercentageHigh->setCurrentIndex(percentageGiven);
        ui->txtName->setText(textGiven);
    }

    QPixmap *pix = new QPixmap(drDef.filename);
    ui->lblPicture->setPixmap(*pix);
    delete pix;pix=0;

}

NewDrink::~NewDrink()
{
    delete ui;
}

void NewDrink::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void NewDrink::on_buttonBox_accepted()
{
    accept=true;
    drDef.amountMl = ui->cmbAmount->currentIndex()*10;
    drDef.percentage = ui->cmbPercentageHigh->currentIndex();
    drDef.text = ui->txtName->text();
}

bool NewDrink::isAccepted()
{
    return accept;
}

void NewDrink::on_btnChange_clicked()
{
    drDef.filename = QFileDialog::getOpenFileName(this, tr("Choose picture"), imagePath, tr("Image Files (*.jpg *.png)"));
    QPixmap *pix = new QPixmap(drDef.filename);
    ui->lblPicture->setPixmap(*pix);
    delete pix;pix=0;

}
