#!/usr/bin/python2.5

#############################################################################
##
## DreamRemote - 2010 by Michael Muth - helex(at)ich.ms
##
## This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
## WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
##
#############################################################################


import sys

from PyQt4 import QtGui, QtCore, QtSql
from Ui_DreamRemote import *
from Ui_Settings import *
from Ui_About import *
import urllib2
import socket
import dbus
import dbus.glib
import time, threading
from os import path
from os import makedirs


from Database import *

global db

global timerQ
global ButtonPressCounter
global ButtonPressCounterFail
ButtonPressCounter = 0    
ButtonPressCounterFail = 0    

global animation
animation = 0

global state
state = "N"

global IP
global Timeout


class frmAbout(QtGui.QDialog):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_About()
        self.ui.setupUi(self)
        msg = "written in Python and Qt\n2010 by Michael Muth\nStatistics: " + str(ButtonPressCounter) + " Button pressed - " + str(ButtonPressCounterFail) + " failed"
        
        msg ="<qt>"
        msg = msg + "written in Python and Qt using PyQt4 bindings<br> "
        msg = msg + "2010 by Michael Muth - "
        msg = msg + "Contact: <a href = mailto:helex@ich.ms>helex@ich.ms</a><br>"
        msg = msg + "<a href = http://dreamremote.garage.maemo.org>http://dreamremote.garage.maemo.org</a><br>"
        msg = msg + "Statistics: " + str(ButtonPressCounter) + " Button pressed - " + str(ButtonPressCounterFail) + " failed<br>"
        msg = msg + "Please consider to donate if you like my work. :-)"
        msg = msg + '<table style="text-align: left; width: 100%;" border="0" cellpadding="0" cellspacing="0"><tbody><tr>'
        msg = msg + '<td style="width: 130px; vertical-align: middle;"><img style="width: 130px; height: 59px;" alt="" src="Buttons/Dream.png"></td>'

        msg = msg + "<td>Inform yourself about the Dreambox<br>"
        msg = msg + 'and Dream Media here: <a href="http://www.dream-multimedia-tv.de/en">Dream Multimedia</a><br>'
        msg = msg + "Compatibe with DM 800, 7025(+), 8000 and all<br>receiver with running Enigma 2 Webinterface."
        msg = msg + "      </td>    </tr>  </tbody></table>"

        self.ui.lblAbout.setText(msg)
        
        self.connect(self.ui.cmdDonate, QtCore.SIGNAL("clicked()"), self.cmdDonate)
        self.connect(self.ui.cmdOk, QtCore.SIGNAL("clicked()"), self.cmdOk)
        self.connect(self.ui.lblAbout, QtCore.SIGNAL("linkActivated(QString)"), self.OpenURL) 

    def OpenURL(self, URL): 
        QtGui.QDesktopServices().openUrl(QtCore.QUrl(URL)) 
        
    def cmdOk(self): 
        print "About - Button Ok clicked"
        self.close()

    def cmdDonate(self):
        print "About - Button Donate clicked"
        QtGui.QDesktopServices().openUrl(QtCore.QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=GYG9EGK5K26PC")) 

class frmSettings(QtGui.QDialog):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_Settings()
        self.ui.setupUi(self)
        self.ui.txtIPa.setText (ReadSetting("IPa"))
        self.ui.txtIPb.setText (ReadSetting("IPb"))
        self.ui.txtIPc.setText (ReadSetting("IPc"))
        self.ui.txtIPd.setText (ReadSetting("IPd"))
        try:
            Timeout = int(ReadSetting("Timeout"))
        except:
            Timeout = 2
        self.ui.SliderTimeout.setValue(Timeout)
        self.ui.lblTimeout.setText(str(Timeout) + " seconds")
        self.connect(self.ui.okButton, QtCore.SIGNAL("clicked()"), self.saveSettings)
        self.connect(self.ui.SliderTimeout, QtCore.SIGNAL('valueChanged(int)'), self.changeValue)


    def changeValue(self, value):
        global Timeout        
        Timeout = int(value)
        s = str(value) + " seconds"
        print ("SliderTimeout changed: ", value)
        self.ui.lblTimeout.setText(s)


    def saveSettings(self):
        print("saveSettings - accept")
        a = str(self.ui.txtIPa.text())
        b = str(self.ui.txtIPb.text())
        c = str(self.ui.txtIPc.text())
        d = str(self.ui.txtIPd.text())
        print ("TextIP:", (a + "." + b + "." + c + "." + d))
        global IP
        IP = str(a + "." + b + "." + c + "." + d)
        StoreSetting("IP", IP)
        StoreSetting("IPa", a)
        StoreSetting("IPb", b)
        StoreSetting("IPc", c)
        StoreSetting("IPd", d)
        global Timeout
        StoreSetting("Timeout", str(Timeout))

   

class MyForm(QtGui.QMainWindow):
   

    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
    

        QtCore.QObject.connect(self.ui.cmd1, QtCore.SIGNAL('clicked()'), self.cmd1)
        QtCore.QObject.connect(self.ui.cmd2, QtCore.SIGNAL('clicked()'), self.cmd2)
        QtCore.QObject.connect(self.ui.cmd3, QtCore.SIGNAL('clicked()'), self.cmd3)
        QtCore.QObject.connect(self.ui.cmd4, QtCore.SIGNAL('clicked()'), self.cmd4)
        QtCore.QObject.connect(self.ui.cmd5, QtCore.SIGNAL('clicked()'), self.cmd5)
        QtCore.QObject.connect(self.ui.cmd6, QtCore.SIGNAL('clicked()'), self.cmd6)
        QtCore.QObject.connect(self.ui.cmd7, QtCore.SIGNAL('clicked()'), self.cmd7)
        QtCore.QObject.connect(self.ui.cmd8, QtCore.SIGNAL('clicked()'), self.cmd8)
        QtCore.QObject.connect(self.ui.cmd9, QtCore.SIGNAL('clicked()'), self.cmd9)
        QtCore.QObject.connect(self.ui.cmd0, QtCore.SIGNAL('clicked()'), self.cmd0)
        QtCore.QObject.connect(self.ui.cmdnext, QtCore.SIGNAL('clicked()'), self.cmdnext)
        QtCore.QObject.connect(self.ui.cmdprevious, QtCore.SIGNAL('clicked()'), self.cmdprevious)
        QtCore.QObject.connect(self.ui.cmdOk, QtCore.SIGNAL('clicked()'), self.cmdOk)
        QtCore.QObject.connect(self.ui.cmdUp, QtCore.SIGNAL('clicked()'), self.cmdUp)
        QtCore.QObject.connect(self.ui.cmdDown, QtCore.SIGNAL('clicked()'), self.cmdDown)
        QtCore.QObject.connect(self.ui.cmdLeft, QtCore.SIGNAL('clicked()'), self.cmdLeft)
        QtCore.QObject.connect(self.ui.cmdRight, QtCore.SIGNAL('clicked()'), self.cmdRight)
        QtCore.QObject.connect(self.ui.cmdMenu, QtCore.SIGNAL('clicked()'), self.cmdMenu)
        QtCore.QObject.connect(self.ui.cmdInfo, QtCore.SIGNAL('clicked()'), self.cmdInfo)
        QtCore.QObject.connect(self.ui.cmdAudio, QtCore.SIGNAL('clicked()'), self.cmdAudio)
        QtCore.QObject.connect(self.ui.cmdVideo, QtCore.SIGNAL('clicked()'), self.cmdVideo)
        QtCore.QObject.connect(self.ui.cmdExit, QtCore.SIGNAL('clicked()'), self.cmdExit)
        QtCore.QObject.connect(self.ui.cmdBUp, QtCore.SIGNAL('clicked()'), self.cmdBUp)
        QtCore.QObject.connect(self.ui.cmdVDown, QtCore.SIGNAL('clicked()'), self.cmdVDown)
        QtCore.QObject.connect(self.ui.cmdBDown, QtCore.SIGNAL('clicked()'), self.cmdBDown)
        QtCore.QObject.connect(self.ui.cmdMute, QtCore.SIGNAL('clicked()'), self.cmdMute)
        QtCore.QObject.connect(self.ui.cmdVup, QtCore.SIGNAL('clicked()'), self.cmdVup)
        QtCore.QObject.connect(self.ui.cmdPower, QtCore.SIGNAL('clicked()'), self.cmdPower)
        QtCore.QObject.connect(self.ui.cmdTV, QtCore.SIGNAL('clicked()'), self.cmdTV)
        QtCore.QObject.connect(self.ui.cmdYellow, QtCore.SIGNAL('clicked()'), self.cmdYellow)
        QtCore.QObject.connect(self.ui.cmdText, QtCore.SIGNAL('clicked()'), self.cmdText)
        QtCore.QObject.connect(self.ui.cmdHelp, QtCore.SIGNAL('clicked()'), self.cmdHelp)
        QtCore.QObject.connect(self.ui.cmdBlue, QtCore.SIGNAL('clicked()'), self.cmdBlue)
        QtCore.QObject.connect(self.ui.cmdRed, QtCore.SIGNAL('clicked()'), self.cmdRed)
        QtCore.QObject.connect(self.ui.cmdGreen, QtCore.SIGNAL('clicked()'), self.cmdGreen)
        QtCore.QObject.connect(self.ui.cmdRadio, QtCore.SIGNAL('clicked()'), self.cmdRadio)
        QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.actionAbout)
        QtCore.QObject.connect(self.ui.actionSettings, QtCore.SIGNAL('triggered()'), self.actionSettings)

        global timerQ
        timerQ = QtCore.QTimer(self) 
        self.connect(timerQ, QtCore.SIGNAL("timeout()"), self ,QtCore.SLOT("update()"))
        self.connect(timerQ, QtCore.SIGNAL("timeout()"), self.updateTimerQ)
        
    def actionSettings(self):
        Settings = frmSettings(self)
        Settings.show()
  
    def actionAbout(self):
        About = frmAbout(self)
        About.show()
        
  
  
    def updateTimerQ (self):
        global timerQ
        global state        
        global animation
        if animation==0:
            animation=10
        else:
          if not animation == 0:
              animation=animation - 1
          if animation==9:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_T01.png"))
          if animation==8:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_T02.png"))
          if animation==7:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_T03.png"))
          if animation==6:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_T04.png"))
          if animation==5:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_R01.png"))
          if animation==4:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_R02.png"))
          if animation==3:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_R03.png"))
          if animation==2:
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_R04.png"))
          if animation==1:
              animation=0
              myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_none.png"))
          if animation == 0:
              if state == "G":
                  myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_good.png"))
                  animation = 0
                  state = "N"
                  timerQ.stop()
              if state == "F":
                  myapp.ui.lblTransmit.setPixmap(QtGui.QPixmap("Buttons/Trainsmit_fault.png"))
                  animation = 0
                  state = "N"
                  timerQ.stop()
        app.processEvents()
    

    
    def cmd1(self): sendCommand("2")
    def cmd2(self): sendCommand("3")
    def cmd3(self): sendCommand("4")
    def cmd4(self): sendCommand("5")
    def cmd5(self): sendCommand("6")
    def cmd6(self): sendCommand("7")
    def cmd7(self): sendCommand("8")
    def cmd8(self): sendCommand("9")
    def cmd9(self): sendCommand("10")
    def cmd0(self): sendCommand("11")
    def cmdnext(self): sendCommand("407")
    def cmdprevious(self): sendCommand("412")
    def cmdOk(self): sendCommand("352")
    def cmdUp(self): sendCommand("103")
    def cmdDown(self): sendCommand("108")
    def cmdLeft(self): sendCommand("105")
    def cmdRight(self): sendCommand("106")
    def cmdMenu(self): sendCommand("139")
    def cmdInfo(self): sendCommand("358")
    def cmdAudio(self): sendCommand("392")
    def cmdVideo(self): sendCommand("393")
    def cmdExit(self): sendCommand("174")
    def cmdBUp(self): sendCommand("402")
    def cmdVDown(self): sendCommand("114")
    def cmdBDown(self): sendCommand("403")
    def cmdMute(self): sendCommand("113")
    def cmdVup(self): sendCommand("115")
    def cmdTV(self): sendCommand("377")
    def cmdYellow(self): sendCommand("400")
    def cmdText(self): sendCommand("388")
    def cmdHelp(self): sendCommand("138")
    def cmdBlue(self): sendCommand("401")
    def cmdRed(self): sendCommand("398")
    def cmdGreen(self): sendCommand("399")
    def cmdRadio(self): sendCommand("385")
    def cmdPower(self): sendCommand("116")



def sendCommand(n):
    global IP
    global Timeout

    global timerQ
    timerQ.start(100)
    global ButtonPressCounterFail
    global ButtonPressCounter
    ButtonPressCounter = ButtonPressCounter + 1

    url = "http://" + str(IP) + "/web/remotecontrol?command="
    print "Send URL: '" + url + n + "' Timeout: " + str(Timeout) + ""

    try:
        socket.setdefaulttimeout(float(Timeout))
    except:
        socket.setdefaulttimeout(2)

    req = urllib2.Request(url + str(n))

    global state  
    try: 
        data = urllib2.urlopen(req)
        print data.read()
        state = "G" #green
    except:
        print ("Error - Command: ", n)
        ButtonPressCounterFail = ButtonPressCounterFail + 1
        state = "F" #red

    print ("Button Press #", ButtonPressCounter)
    
    StoreSetting("BPCounterFail", str(ButtonPressCounterFail))
    StoreSetting("BPCounter", str(ButtonPressCounter))
  
  
  


if __name__ == "__main__":
  
    MCE_SIGNAL_NAME = 'sig_device_orientation_ind'
    MCE_SIGNAL_IFACE = 'com.nokia.mce.signal'
    MCE_SIGNAL_PATH = '/com/nokia/mce/signal'
  
    system_bus = dbus.Bus.get_system()


    def handler(orientation, stand, face, x, y, z):
        print orientation




    system_bus.add_signal_receiver(handler, signal_name=MCE_SIGNAL_NAME, \
      dbus_interface=MCE_SIGNAL_IFACE, path=MCE_SIGNAL_PATH)

    dbfile = '/home/user/.dreamremote/DreamRemote.db'
    
    dbpath = path.dirname(dbfile)
    if path.exists(dbpath):
        print "Settings Directory exit"
    else:
        print "create Settings Directory"
        makedirs(dbpath)

    if not createConnection(dbfile):
        print "Database error - failed to open and connect"
        sys.exit(66)

    global IP
    global Timeout
    
    IP = ReadSetting("IP")
    Timeout = ReadSetting("Timeout")
    try:
        ButtonPressCounterFail = int(ReadSetting("BPCounterFail"))
    except:
        ButtonPressCounterFail = 0 
    try:
        ButtonPressCounter = int(ReadSetting("BPCounter"))
    except:
        ButtonPressCounter = 0     
    
    app = QtGui.QApplication(sys.argv)
    myapp = MyForm()

    myapp.show()
  
  


    x = app.exec_()



    closeConnection()
    if x == 0:
        print "Database closed - DreamRemote finished successfull"
    sys.exit(x)

