#include "mainwindowdesktop.h"
#include "ui_mainwindowdesktop.h"

MainWindowDesktop::MainWindowDesktop(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindowDesktop)
{
    ui->setupUi(this);

    netAccessMan = new QNetworkAccessManager(this);
    connect(netAccessMan, SIGNAL(finished(QNetworkReply*)), this, SLOT(downloadFinished(QNetworkReply*)));
}

MainWindowDesktop::~MainWindowDesktop(){
    delete ui;
}

void MainWindowDesktop::on_btnSearch_clicked()
{
    download("http://maemo.dadablog.net/AppStats.php?package="+ui->edtPackage->text()+"&os=fremantle");

    movie = new QMovie(":/loading.gif");

    if (movie->isValid()){
	ui->lblDownloading->setMovie(movie);
	movie->start();
    }else{
	ui->lblDownloading->setPixmap(QPixmap(":/loading.gif"));
    }
}

void MainWindowDesktop::download(QString item){
    QUrl url(item);
    QNetworkRequest request(url);
    netAccessMan->get(request);
}


void MainWindowDesktop::downloadFinished(QNetworkReply *reply){
    if (reply->error() != QNetworkReply::NoError) {
	ui->edtPackage->setText("maemo.dadablog.net is not available");
	reply->deleteLater();
	return;
    }

    QVariant redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);
    if (redir.isValid()) {
	QUrl url = redir.toUrl();
	//qDebug() << "must go to:" << url;
	if (url.isRelative()) {
	    url.setScheme(reply->url().scheme());
	    url.setEncodedHost(reply->url().encodedHost());
	}
	QNetworkRequest req(url);
	netAccessMan->get(req);
	reply->deleteLater();
	return;
    }
    //ui->edtPackage->setText("ContentType:" +reply->header(QNetworkRequest::ContentTypeHeader).toString());

    downloadedItem = reply->readAll();

    if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/xml"){

    }else if (reply->header(QNetworkRequest::ContentTypeHeader).toString()=="text/html"){
	QString statistics=downloadedItem;

	int totalBegins=statistics.indexOf("<b>Total</b></td><td><b>")+24;
	int totalEnds=statistics.indexOf("</b></td></tr>",totalBegins)+14;
	ui->edtTotal->setText(statistics.mid(totalBegins,totalEnds-totalBegins-14));

	if (ui->edtTotal->text()!="0"){
	    int extrasBegins=statistics.indexOf("Maemo.org Extras Total</b></td><td><b>")+38;
	    int extrasEnds=statistics.indexOf("</b></td></tr>",extrasBegins)+14;
	    ui->edtExtras->setText(statistics.mid(extrasBegins,extrasEnds-extrasBegins-14));

	    int extrasTestingBegins=statistics.indexOf("Maemo.org Extras-Testing Total</b></td><td><b>")+46;
	    int extrasTestingEnds=statistics.indexOf("</b></td></tr>",extrasTestingBegins)+14;
	    ui->edtExtrasTesting->setText(statistics.mid(extrasTestingBegins,extrasTestingEnds-extrasTestingBegins-14));

	    int extrasDevelBegins=statistics.indexOf("Maemo.org Extras-Devel Total</b></td><td><b>")+44;
	    int extrasDevelEnds=statistics.indexOf("</b></td></tr>",extrasDevelBegins)+14;
	    ui->edtExtrasDevel->setText(statistics.mid(extrasDevelBegins,extrasDevelEnds-extrasDevelBegins-14));
	}else{
	    ui->edtExtras->setText("0");
	    ui->edtExtrasTesting->setText("0");
	    ui->edtExtrasDevel->setText("0");
	}
    }

    reply->deleteLater();

    ui->lblDownloading->setPixmap(QPixmap("/invisible.png"));
}
