#ifndef MAINWINDOWMAEMO_H
#define MAINWINDOWMAEMO_H

#include "headers.h"

namespace Ui {
    class MainWindowMaemo;
}

class MainWindowMaemo : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindowMaemo(QWidget *parent = 0);
    ~MainWindowMaemo();


    enum ScreenOrientation {
	ScreenOrientationLockPortrait,
	ScreenOrientationLockLandscape,
	ScreenOrientationAuto
    };

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

public slots:
    void reorderUI();

private slots:
    void on_btnSearch_clicked();
    void download(QString item);
    void downloadFinished(QNetworkReply *reply);

    void on_edtPackage_textChanged(const QString &arg1);

private:
    Ui::MainWindowMaemo *ui;
    QNetworkAccessManager *netAccessMan;
    QByteArray downloadedItem;
    QMovie *movie;

};

#endif // MAINWINDOWMAEMO_H
