/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2013 Alexis Megas, Bernd Stramm,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#include "dplugintab.h"

#include <QDebug>
#include <QAction>
#include <QHBoxLayout>
#include <QMessageBox>

using namespace simpleplugin;

dplugintab::dplugintab(Extension *ext, QWidget *parent):QWidget(parent),
							extWidget(0),
							m_extension(ext),
							sagent(0)
{
  setLayout(new QHBoxLayout());
  layout()->setContentsMargins(0, 0, 0, 0);
  m_action = 0;

  if(m_extension)
    {
      extWidget = m_extension->widget();

      if(extWidget)
	{
	  extWidget->resize(size());
	  layout()->addWidget(extWidget);
	}

      sagent = m_extension->agent();

      if(sagent)
	connect(sagent, SIGNAL(exiting(Extension *, int)),
		this, SLOT(emitExiting(Extension *, int)));
    }
}

dplugintab::~dplugintab()
{
  if(m_action)
    m_action->deleteLater();

  if(sagent)
    disconnect(sagent, 0,0,0);

  /*
  ** We need to set the plugin's widget's parent to 0. Otherwise,
  ** Dooble will abort.
  */

  if(extWidget && extWidget->parent() == this)
    extWidget->setParent(0);
}

QWidget *dplugintab::pluginWidget(void) const
{
  return extWidget;
}

QIcon dplugintab::icon(void) const
{
  if(m_extension)
    return m_extension->icon();

  return QIcon();
}

QString dplugintab::title(void) const
{
  if(m_extension)
    return m_extension->title();

  return QString();
}

bool dplugintab::canClose(void) const
{
  if(m_extension)
    return m_extension->canRestart();
  else
    return true;
}

void dplugintab::close(void)
{
  if(m_extension)
    m_extension->quit();
}

void dplugintab::emitExiting(Extension *ex, int status)
{
  Q_UNUSED(ex);
  emit exiting(this, status);
}

void dplugintab::resizeEvent(QResizeEvent *event)
{
  if(extWidget)
    extWidget->resize(size());

  QWidget::resizeEvent(event);
}

void dplugintab::slotIconChange(Extension *ext)
{
  if(ext == m_extension && ext)
    emit iconChange(this, m_extension->icon());
}

void dplugintab::slotTitleChange(Extension *ext)
{
  if(ext == m_extension && ext)
    emit titleChange(this, m_extension->title());
}

Extension *dplugintab::extension(void) const
{
  return m_extension;
}

void dplugintab::setTabAction(QAction *action)
{
  if(m_action)
    {
      removeAction(m_action);
      m_action->deleteLater();
    }

  m_action = action;

  if(m_action)
    addAction(m_action);
}

QAction *dplugintab::tabAction(void) const
{
  return m_action;
}
