/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dcookies_h_
#define _dcookies_h_

#include <QHash>
#include <QMutex>
#include <QFuture>
#include <QNetworkCookieJar>

class QTimer;
class QProgressBar;

class dexceptionswindow;

class dcookies: public QNetworkCookieJar
{
  Q_OBJECT

 public:
  dcookies(const bool arePrivate, QObject *parent = 0);
  ~dcookies();
  bool isFavorite(const QString &domain) const;
  bool setCookiesFromUrl(const QList<QNetworkCookie> &cookieList,
			 const QUrl &url);
  void clear(void);
  void populate(void);
  void reencode(QProgressBar *progress);
  void allowDomain(const QString &domain,
		   const bool allowed);
  void removeCookie(const QNetworkCookie &cookie);
  void removeDomains(const QStringList &domains);
  qint64 size(void) const;
  QList<QNetworkCookie> allCookies(void) const;
  QList<QNetworkCookie> cookiesForUrl(const QUrl &url) const;
  QList<QNetworkCookie> allCookiesAndFavorites(void) const;

 private:
  bool m_arePrivate;
  bool m_stopWriteThread;
  QMutex m_stopMutex;
  QMutex m_writeMutex;
  QTimer *m_timer;
  QTimer *m_writeTimer;
  QFuture<void> m_future;
  QHash<QString, bool> m_favorites;
  int computedTimerInterval(void) const;
  void makeTimeToWrite(void);
  void createCookieDatabase(void);
  void deleteAndSaveCookies(void);
  void deleteAndSaveFavorites(void);

 public slots:
  void slotWriteTimeout(void);
  void slotCookieTimerChanged(void);

 private slots:
  void slotClear(void);
  void slotRemoveDomains(void);

 signals:
  void changed(void);
  void cookieReceived(const QString &host,
		      const QUrl &url,
		      const QDateTime &dateTime);
  void domainsRemoved(const QStringList &list);
  void exceptionRaised(dexceptionswindow *window,
		       const QUrl &url);
};

#endif
