/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#include "dooble.h"
#include "dspoton.h"

#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
#ifdef Q_OS_WIN32
#define LIBSPOTON_OS_WINDOWS 1
#endif

extern "C"
{
#include "LibSpotOn/libspoton.h"
}
#endif

dspoton::dspoton(void)
{
#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
  connect(&m_timer,
	  SIGNAL(timeout(void)),
	  this,
	  SLOT(slotTimeout(void)));
  m_timer.start(5000);
#endif
}

dspoton::~dspoton()
{
#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
  m_timer.stop();
#endif
}

bool dspoton::isKernelRegistered(void)
{
  bool registered = false;
#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
  libspoton_error_t err = LIBSPOTON_ERROR_NONE;
  libspoton_handle_t libspotonHandle;

  if((err = libspoton_init(dooble::s_settings.
			   value("settingsWindow/"
				 "spotOnSharedDatabase").toString().
			   toStdString().c_str(),
			   &libspotonHandle)) == LIBSPOTON_ERROR_NONE)
    registered = libspoton_is_kernel_registered(&libspotonHandle);

  libspoton_close(&libspotonHandle);
#endif
  return registered;
}

void dspoton::registerWidget(QWidget *widget)
{
#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
  connect(this,
	  SIGNAL(spotonKernelRegistered(bool)),
	  widget,
	  SLOT(setEnabled(bool)));
#else
  Q_UNUSED(widget);
#endif
}

void dspoton::share(const QUrl &url,
		    const QString &title,
		    const QString &description)
{
#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
  if(dmisc::s_crypt)
    {
      libspoton_error_t err = LIBSPOTON_ERROR_NONE;
      libspoton_handle_t libspotonHandle;

      if((err = libspoton_init(dooble::s_settings.
			       value("settingsWindow/"
				     "spotOnSharedDatabase").toString().
			       toStdString().c_str(),
			       &libspotonHandle)) == LIBSPOTON_ERROR_NONE)
	err = libspoton_save_url
	  (url.toEncoded(QUrl::StripTrailingSlash).constData(),
	   url.toEncoded(QUrl::StripTrailingSlash).size(),
	   title.toUtf8().constData(),
	   title.toUtf8().size(),
	   description.toUtf8().constData(),
	   description.toUtf8().size(),
	   dmisc::s_crypt->key(),
	   dmisc::s_crypt->keyLength(),
	   &libspotonHandle);

      libspoton_close(&libspotonHandle);
    }
#else
  Q_UNUSED(description);
  Q_UNUSED(title);
  Q_UNUSED(url);
#endif
}

#ifdef DOOBLE_LINKED_WITH_LIBSPOTON
void dspoton::slotTimeout(void)
{
  emit spotonKernelRegistered(isKernelRegistered());
}
#endif
