/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _durlwidget_h_
#define _durlwidget_h_

#include <QLineEdit>
#include <QCompleter>
#include <QTableView>
#include <QToolButton>

class QMouseEvent;
class QStandardItem;
class QStandardItemModel;

class durlcompleterview: public QTableView
{
  Q_OBJECT

 public:
  durlcompleterview(void);

 private:
  void wheelEvent(QWheelEvent *event);
  void mouseMoveEvent(QMouseEvent *event);
};

class durlcompleter: public QCompleter
{
  Q_OBJECT

 public:
  durlcompleter(QWidget *parent);
  ~durlcompleter();
  bool exists(const QString &text) const;
  void clear(void);
  void setModel(QStandardItemModel *model);
  void saveItemUrl(const QString &url);
  void setCompletion(const QString &completion);
  void copyContentsOf(durlcompleter *c);

 private:
  QStringList m_allUrls;
  durlcompleterview *m_tableView;
  QStandardItemModel *m_model;
  QList<QStandardItem *> m_purgedItems;
};

class durlwidgettoolbutton: public QToolButton
{
  Q_OBJECT

 public:
  durlwidgettoolbutton(QWidget *parent);

 private:
  void mousePressEvent(QMouseEvent *event);
};

class durlwidget: public QLineEdit
{
  Q_OBJECT

 public:
  durlwidget(QWidget *parent);
  int findText(const QString &text) const;
  bool isBookmarkeButtonEnabled(void) const;
  void addItem(const QString &text);
  void addItem(const QString &text, const QIcon &icon);
  void popdown(void) const;
  void setIcon(const QIcon &icon);
  void setText(const QString &text);
  void selectAll(void);
  void appendItem(const QString &text, const QIcon &icon);
  void appendItems(const QMultiMap<QDateTime, QVariantList> &items);
  void resizeEvent(QResizeEvent *);
  void setItemIcon(const int index, const QIcon &icon);
  void clearHistory(void);
  void copyContentsOf(durlwidget *c);
  void setSecureColor(const bool isHttps);
  void setBookmarkColor(const bool isBookmarked);
  void setBookmarkButtonEnabled(const bool state);
  QPoint bookmarkButtonPopupPosition(void) const;

 private:
  int m_counter;
  QToolButton *goToolButton;
  QToolButton *iconToolButton;
  QToolButton *bookmarkToolButton;
  QToolButton *m_fakePulldownMenu;
  durlcompleter *m_completer;
  bool event(QEvent *e);
  void keyPressEvent(QKeyEvent *event);

 public slots:
  void slotSetIcons(void);

 private slots:
  void slotBookmark(void);
  void slotLoadPage(void);
  void slotLoadPage(const QString &url);
  void slotReturnPressed(void);
  void slotPulldownClicked(void);

 signals:
  void bookmark(void);
  void loadPage(const QUrl &url);
  void resetUrl(void);
  void openLinkInNewTab(const QUrl &url);
};

#endif
