/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2012 Alexis Megas, Bernd Stramm,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dtabwidget_h_
#define _dtabwidget_h_

#include <QUrl>
#include <QTabBar>
#include <QTabWidget>

class QToolButton;

class dtabbar: public QTabBar
{
  Q_OBJECT

 public:
  dtabbar(QWidget *parent);
  QSize tabSizeHint(int index) const;

 private:
  void dropEvent(QDropEvent *event);
  void dragMoveEvent(QDragMoveEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
  void mouseDoubleClickEvent(QMouseEvent *event);

 signals:
  void createTab(void);
  void urlsReceivedViaDrop(const QList<QUrl> &list);
};

class dtabwidget: public QTabWidget
{
  Q_OBJECT

 public:
  dtabwidget(QWidget *parent);
  ~dtabwidget();
  void animateIndex(const int index, const bool state, const QIcon &icon);
  void setTabButton(int index);
  void setBarVisible(const bool state);

 private:
  int m_selectedTabIndex;
  QString m_spinningIconPath;
  dtabbar *m_tabBar;
#ifndef Q_OS_MAC
  QToolButton *m_addTabButton;
#endif
  void dropEvent(QDropEvent *event);
  void tabRemoved(int index);
  void resizeEvent(QResizeEvent *event);
  void tabInserted(int index);
  void dragMoveEvent(QDragMoveEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
  void mousePressEvent(QMouseEvent *event);
  void positionAddTabButton(void);
#ifndef Q_OS_MAC
  void mouseDoubleClickEvent(QMouseEvent *event);
#endif

 public slots:
  void slotSetIcons(void);
  void slotIconChange(QWidget *tab, const QIcon &icon);
  void slotTitleChange(QWidget *tab, const QString &title);

 private slots:
  void slotBookmark(void);
  void slotCloseTab(void);
  void slotCloseTab(int index);
  void slotCreateTab(void);
  void slotReloadTab(void);
  void slotCloseOtherTabs(void);
  void slotPrivateCookies(void);
  void slotOpenInNewWindow(void);
  void slotShowContextMenu(const QPoint &point);
  void slotViewPrivateCookies(void);

 signals:
  void bookmark(const int index);
  void closeTab(const int index);
  void tabMoved(int from, int to);
  void createTab(void);
  void reloadTab(const int index);
  void openInNewWindow(const int index);
  void openLinkInNewTab(const QUrl &url);
  void urlsReceivedViaDrop(const QList<QUrl> &list);
};

#endif
