libspoton.target = libspoton.dylib
libspoton.commands = $(MAKE) -C LibSpotOn
libspoton.depends =
purge.commands = rm -f Doc/*~ Include/*~ Installers/*~ \
                 Source/*~ *~

TEMPLATE	= app
LANGUAGE	= C++
QT		+= concurrent network sql v8 xml \
		   webkit webkitwidgets widgets
CONFIG		+= app_bundle qt release warn_on

# The function gcry_kdf_derive() is available in version
# 1.5.0 of the gcrypt library.

DEFINES         += DOOBLE_LINKED_WITH_LIBSPOTON \
                   DOOBLE_MINIMUM_GCRYPT_VERSION=0x010500

# Unfortunately, the clean target assumes too much knowledge
# about the internals of LibSpotOn.

QMAKE_CLEAN     += Dooble LibSpotOn/*.dylib LibSpotOn/*.o LibSpotOn/test
QMAKE_DISTCLEAN += -r temp
QMAKE_CXXFLAGS_DEBUG -= -O2
QMAKE_CXXFLAGS_DEBUG += -mtune=generic -Os \
			-Wall -Wcast-align -Wcast-qual \
                        -Werror -Wextra \
			-Woverloaded-virtual -Wpointer-arith
QMAKE_CXXFLAGS_RELEASE -= -O2
QMAKE_CXXFLAGS_RELEASE += -mtune=generic -O3 \
			  -Wall -Wcast-align -Wcast-qual \
                          -Werror -Wextra \
			  -Woverloaded-virtual -Wpointer-arith
QMAKE_EXTRA_TARGETS = libspoton purge
QMAKE_LFLAGS_RELEASE =
QMAKE_LFLAGS_RPATH =
INCLUDEPATH	+= . Include Include.osx64
ICON		= Icons/AxB/dooble.icns
LIBS		+= -LLibraries.osx64 -LLibSpotOn -lgcrypt -lspoton -lstdc++.6
PRE_TARGETDEPS = libspoton.dylib
OBJECTS_DIR = temp/obj
UI_DIR = temp/ui
MOC_DIR = temp/moc
RCC_DIR = temp/rcc

FORMS           = UI/applicationPropertiesWindow.ui \
		  UI/bookmarksPopup.ui \
		  UI/bookmarksWindow.ui \
		  UI/clearContainersWindow.ui \
		  UI/cookieWindow.ui \
		  UI/downloadPrompt.ui \
		  UI/downloadWindowItem.ui \
                  UI/downloadWindow.ui \
		  UI/errorLog.ui \
		  UI/exceptionsWindow.ui \
		  UI/fileManagerForm.ui \
		  UI/ftpManagerForm.ui \
		  UI/historySideBar.ui \
		  UI/historyWindow.ui \
		  UI/mainWindow.ui \
                  UI/pageSourceWindow.ui \
                  UI/passphrasePrompt.ui \
		  UI/passwordPrompt.ui \
		  UI/reinstateWidget.ui \
		  UI/settings.ui \
		  UI/statusBar.ui

UI_HEADERS_DIR  = Include

HEADERS		= Include/dbookmarkspopup.h \
		  Include/dbookmarkstree.h \
		  Include/dbookmarkswindow.h \
		  Include/dclearcontainers.h \
		  Include/dcookies.h \
		  Include/dcookiewindow.h \
		  Include/ddesktopwidget.h \
		  Include/ddownloadprompt.h \
		  Include/ddownloadwindow.h \
                  Include/ddownloadwindowitem.h \
		  Include/derrorlog.h \
		  Include/dexceptionsmodel.h \
                  Include/dexceptionswindow.h \
		  Include/dfilemanager.h \
		  Include/dfilesystemmodel.h \
		  Include/dftp.h \
		  Include/dftpbrowser.h \
		  Include/dgenericsearchwidget.h \
		  Include/dhistory.h \
		  Include/dhistorymodel.h \
		  Include/dhistorysidebar.h \
                  Include/dmarker.h \
		  Include/dmisc.h \
		  Include/dnetworkaccessmanager.h \
		  Include/dnetworkcache.h \
		  Include/dooble.h \
                  Include/dpagesourcewindow.h \
                  Include/dplugintab.h \
		  Include/dreinstatedooble.h \
		  Include/dsearchwidget.h \
                  Include/dsettings.h \
                  Include/dsettingshomelinewidget.h \
		  Include/dspoton.h \
		  Include/dtabwidget.h \
		  Include/durlwidget.h \
		  Include/dview.h \
                  Include/dwebpage.h \
		  Include/dwebview.h

PLUGIN_HEADERS =  plugin-spec/extension.h \
                  plugin-spec/signal-agent.h

HEADERS += $$(PLUGIN_HEADERS)

SOURCES		= Source/dbookmarkspopup.cc \
		  Source/dbookmarkstree.cc \
		  Source/dbookmarkswindow.cc \
		  Source/dclearcontainers.cc \
		  Source/dcookies.cc \
		  Source/dcookiewindow.cc \
		  Source/dcrypt.cc \
		  Source/ddesktopwidget.cc \
		  Source/ddownloadprompt.cc \
		  Source/ddownloadwindow.cc \
                  Source/ddownloadwindowitem.cc \
		  Source/derrorlog.cc \
		  Source/dexceptionsmodel.cc \
                  Source/dexceptionswindow.cc \
		  Source/dfilemanager.cc \
		  Source/dfilesystemmodel.cc \
		  Source/dftp.cc \
		  Source/dftpbrowser.cc \
		  Source/dgenericsearchwidget.cc \
		  Source/dhistory.cc \
		  Source/dhistorymodel.cc \
		  Source/dhistorysidebar.cc \
                  Source/dmarker.cc \
		  Source/dmisc.cc \
		  Source/dnetworkaccessmanager.cc \
		  Source/dnetworkcache.cc \
		  Source/dooble.cc \
                  Source/dpagesourcewindow.cc \
                  Source/dplugintab.cc \
		  Source/dreinstatedooble.cc \
		  Source/dsearchwidget.cc \
                  Source/dsettings.cc \
                  Source/dsettingshomelinewidget.cc \
		  Source/dspoton.cc \
		  Source/dtabwidget.cc \
		  Source/durlwidget.cc \
		  Source/dview.cc \
                  Source/dwebpage.cc \
		  Source/dwebview.cc

RESOURCES       += Tab/Default/htmls.qrc

TRANSLATIONS    = Translations/dooble_en.ts \
                  Translations/dooble_ae.ts \
                  Translations/dooble_al_sq.ts \
                  Translations/dooble_af.ts \
                  Translations/dooble_al.ts \
                  Translations/dooble_am.ts \
                  Translations/dooble_as.ts \
                  Translations/dooble_az.ts \
                  Translations/dooble_ast.ts \
                  Translations/dooble_be.ts \
                  Translations/dooble_bd_bn.ts \
                  Translations/dooble_bg.ts \
                  Translations/dooble_ca.ts \
                  Translations/dooble_crh.ts \
                  Translations/dooble_cz.ts \
                  Translations/dooble_de.ts \
                  Translations/dooble_dk.ts \
                  Translations/dooble_ee.ts \
                  Translations/dooble_es.ts \
                  Translations/dooble_eo.ts \
                  Translations/dooble_et.ts \
                  Translations/dooble_eu.ts \
                  Translations/dooble_fi.ts \
                  Translations/dooble_fr.ts \
                  Translations/dooble_galician.ts \
                  Translations/dooble_gl.ts \
                  Translations/dooble_gr.ts \
                  Translations/dooble_hb.ts \
                  Translations/dooble_hi.ts \
                  Translations/dooble_hr.ts \
                  Translations/dooble_hu.ts \
                  Translations/dooble_it.ts \
                  Translations/dooble_il.ts \
                  Translations/dooble_ie.ts \
                  Translations/dooble_id.ts \
                  Translations/dooble_jp.ts \
                  Translations/dooble_kk.ts \
                  Translations/dooble_kn.ts \
                  Translations/dooble_ko.ts \
                  Translations/dooble_ky.ts \
                  Translations/dooble_ku.ts \
                  Translations/dooble_lt.ts \
                  Translations/dooble_lk.ts \
                  Translations/dooble_lv.ts \
                  Translations/dooble_ml.ts \
                  Translations/dooble_mk.ts \
                  Translations/dooble_mn.ts \
                  Translations/dooble_ms.ts \
                  Translations/dooble_my-bn.ts \
                  Translations/dooble_mr.ts \
                  Translations/dooble_mt.ts \
                  Translations/dooble_nl.ts \
                  Translations/dooble_no.ts \
                  Translations/dooble_np.ts \
                  Translations/dooble_pl.ts \
                  Translations/dooble_pa.ts \
                  Translations/dooble_pt.ts \
                  Translations/dooble_pt-BR.ts \
                  Translations/dooble_ps.ts \
                  Translations/dooble_ro.ts \
                  Translations/dooble_ru.ts \
                  Translations/dooble_rw.ts \
                  Translations/dooble_se.ts \
                  Translations/dooble_sk.ts \
                  Translations/dooble_sl.ts \
                  Translations/dooble_sr.ts \
                  Translations/dooble_sq.ts \
                  Translations/dooble_sw.ts \
                  Translations/dooble_th.ts \
                  Translations/dooble_tr.ts \
                  Translations/dooble_vn.ts \
                  Translations/dooble_zh-CN-simple.ts \
                  Translations/dooble_zh-TW.ts \
                  Translations/dooble_zh-CN-traditional.ts \
                  Translations/dooble_Arab_BH_DZ_EG_IQ_JO_KW_LY_MA_OM_QA_SA_SY_YE.ts \
                  Translations/dooble_French_BE_BJ_BF_BI_FR_KM_CD_CI_DJ_DM_PF_TF_GA_GN_HT_LB_LU_ML_MR_YT_MC_NC_NE_NG_SN_TG_TN.ts \
                  Translations/dooble_Portuguese_AO_BR_CV_GW_MO_MZ_ST_TL.ts

TARGET		= Dooble
PROJECTNAME	= Dooble

dooble.path		= /Applications/Dooble_Qt5.d/Dooble.app
dooble.files		= Dooble.app/*
icons.path		= /Applications/Dooble_Qt5.d
icons.files		= Icons
images.path		= /Applications/Dooble_Qt5.d
images.files		= Images
libmisc_install.path    = .
libmisc_install.extra   = cp ./Libraries.osx64/*.dylib ./Dooble.app/Contents/Frameworks/.
libspoton_install.path  = .
libspoton_install.extra = cp ./LibSpotOn/libspoton.dylib ./Dooble.app/Contents/Frameworks/libspoton.dylib && install_name_tool -change /usr/local/lib/libgcrypt.11.dylib @loader_path/libgcrypt.11.dylib ./Dooble.app/Contents/Frameworks/libspoton.dylib && install_name_tool -change ./LibSpotOn/libspoton.dylib @executable_path/../Frameworks/libspoton.dylib ./Dooble.app/Contents/MacOS/Dooble
lrelease.extra          = $$[QT_INSTALL_BINS]/lrelease dooble.osx.pro
lrelease.path           = .
lupdate.extra           = $$[QT_INSTALL_BINS]/lupdate dooble.osx.pro
lupdate.path            = .
macdeployqt.path        = ./Dooble.app
macdeployqt.extra       = $$[QT_INSTALL_BINS]/macdeployqt ./Dooble.app -verbose=0
postinstall.path	= /Applications/Dooble_Qt5.d
postinstall.extra	= find /Applications/Dooble_Qt5.d -name .svn -exec rm -rf {} \\; 2>/dev/null; echo
translations.path 	= /Applications/Dooble_Qt5.d/Translations
translations.files	= Translations/*.qm

# Prevent qmake from stripping everything.

QMAKE_STRIP	= echo
INSTALLS	= macdeployqt \
                  libmisc_install \
                  libspoton_install \
                  icons \
                  images \
                  lupdate \
                  lrelease \
                  translations \
                  dooble \
                  postinstall
