/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#include <QMenu>
#include <QStyle>
#include <QLocale>
#include <QSettings>
#include <QResizeEvent>

#include "dooble.h"
#include "dsearchwidget.h"

dsearchwidget::dsearchwidget(QWidget *parent):QLineEdit(parent)
{
  findToolButton = new QToolButton(this);
  findToolButton->setToolTip(tr("Initiate Search"));
  findToolButton->setIconSize(QSize(16, 16));
  findToolButton->setCursor(Qt::ArrowCursor);
  findToolButton->setStyleSheet("QToolButton {"
				"border: none; "
				"padding-top: 0px; "
				"padding-bottom: 0px; "
				"}");
  pulldownToolButton = new QToolButton(this);
  pulldownToolButton->setCursor(Qt::ArrowCursor);
  pulldownToolButton->setIcon(QIcon("Icons/16x16/dooble.png"));
  pulldownToolButton->setIconSize(QSize(16, 16));
  pulldownToolButton->setStyleSheet
    ("QToolButton {"
     "border: none; "
     "padding-top: 0px; "
     "padding-bottom: 0px; "
#ifdef Q_WS_MAC
     "padding-right: 10px; "
#else
     "padding-right: 15px; "
#endif
     "}"
     "QToolButton::menu-button {border: none; padding-right: 5px;}");

  QMenu *menu = new QMenu(this);

  m_type = "history";
  menu->setActiveAction(menu->addAction(QIcon("Icons/16x16/dooble.png"),
					"History"));
  menu->addSeparator();
  menu->addAction(QIcon("Icons/16x16/blekko.png"), "Blekko");
  menu->addAction(QIcon("Icons/16x16/dogpile.png"), "Dogpile");
  menu->addAction(QIcon("Icons/16x16/duckduckgo.png"), "DuckDuckGo");
  menu->addAction(QIcon("Icons/16x16/google.png"), "Google");
  menu->addAction(QIcon("Icons/16x16/ixquick.png"), "Ixquick");
  menu->addAction(QIcon("Icons/16x16/metager.png"), "MetaGer");
  menu->addAction(QIcon("Icons/16x16/wikinews.png"), "Wikinews");
  menu->addAction(QIcon("Icons/16x16/wikipedia.png"), "Wikipedia");
  menu->addAction(QIcon("Icons/16x16/wolframalpha.png"), "WolframAlpha");
  menu->addAction(QIcon("Icons/16x16/yacy.png"), "YaCy");
  setPlaceholderText(menu->activeAction()->text());
  connect(menu, SIGNAL(triggered(QAction *)), this,
	  SLOT(slotSearchTypeChanged(QAction *)));
  pulldownToolButton->setMenu(menu);
  pulldownToolButton->setPopupMode(QToolButton::MenuButtonPopup);
  connect(pulldownToolButton, SIGNAL(clicked(void)),
	  pulldownToolButton, SLOT(showMenu(void)));
  slotSetIcons();

  int frameWidth = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);

  setStyleSheet
    (QString("QLineEdit {padding-right: %1px; padding-left: %2px; "
	     "selection-background-color: darkgray;}").arg
     (findToolButton->sizeHint().width() + frameWidth + 5).arg
     (pulldownToolButton->sizeHint().width() + frameWidth + 5));
  setMinimumHeight(sizeHint().height() + 10);

  if(dooble::s_settings.contains("mainWindow/searchName"))
    {
      QString searchName(dooble::s_settings.value("mainWindow/searchName").
			 toString());

      for(int i = 0; i < menu->actions().size(); i++)
	if(menu->actions().at(i)->text() == searchName)
	  {
	    /*
	    ** Please note that "mainWindow/searchName" will be set
	    ** again in slotSearchTypeChanged().
	    */

	    slotSearchTypeChanged(menu->actions().at(i));
	    break;
	  }
    }
}

void dsearchwidget::resizeEvent(QResizeEvent *event)
{
  int frameWidth = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);
  QSize size1 = findToolButton->sizeHint();
  QSize size2 = pulldownToolButton->sizeHint();

  findToolButton->move
    (rect().right() - frameWidth - size1.width() - 5,
     (rect().bottom() + 2 - size1.height()) / 2);
  pulldownToolButton->move
    (frameWidth - rect().left() + 6,
     (rect().bottom() + 2 - size2.height()) / 2);
  QLineEdit::resizeEvent(event);
}

QString dsearchwidget::type(void) const
{
  if(m_type.isEmpty())
    return "history";
  else
    return m_type;
}

QToolButton *dsearchwidget::findButton(void) const
{
  return findToolButton;
}

void dsearchwidget::slotSearchTypeChanged(QAction *action)
{
  if(!action)
    return;

  setPlaceholderText(action->text());
  m_type = action->text().toLower();
  pulldownToolButton->setIcon(action->icon());

  QSettings settings;

  settings.setValue("mainWindow/searchName", action->text());
  dooble::s_settings["mainWindow/searchName"] = action->text();
}

void dsearchwidget::slotSetIcons(void)
{
  QSettings settings
    (dooble::s_settings.value("iconSet").toString(), QSettings::IniFormat);

  settings.beginGroup("searchWidget");
  findToolButton->setIcon
    (QIcon(settings.value("findToolButton").toString()));
}
