#!/bin/bash
#
# this script packages the sources needed for linux packages
# as such it should _not_ include executable libraries,
# whether shared or static, nor exectable binary programs,
# nor files needed to install Windows, or OS-X packages
#

function usage () {
  echo "$0: usage"
  echo "	--rev=<revision>"
  echo "		use specific svn revision"
  echo "		otherwise use current workspace"
  echo "	--version=<version>"
  echo "		force version number"
  echo "		otherwise use version from workspace"
  echo "	obs"
  echo "		copy to obs soft links"
  echo "	<dir>"
  echo "		assume dooble code is in <dir>"
  echo "		otherwise assume ../.."
  echo "	--help"
  echo "		show this message"
}

function list_contains_count () {
  local FIRST REST
  FIRST=$1
  shift
  REST=$*
  LIST_COUNT=0
  for X in $REST; do
    if [ "X$X" == "X${FIRST}" ]; then
      LIST_COUNT=$((LIST_COUNT + 1))
    fi
  done
}


function find_path () {
   local FIRST REST
   REST=$*
   for X in $REST; do
     if [ -d $X ]; then  # a directory - assume this is the as path to dooble
       DOOBLE_SRC_ROOT=$X
       return
     fi
   done
}

function find_optval () {
  local SUBHEAD SUBLEN
  local FIRST REST
  local MATCH OPTPART
  OPTVAL=""
  SUBHEAD=$1
  SUBLEN=${#SUBHEAD}
  shift
  REST=$*
  for X in $REST; do
    MATCH=`expr match $X $SUBHEAD`
    if [ $MATCH -eq $SUBLEN ]; then
       OPTVAL=${X:$SUBLEN}
       return 0
    fi
  done
  return 1
}

DOOBLE_SRC_ROOT=../..
ORIGIN=$PWD
ALL_ARGS=$*

find_optval "--help" $ALL_ARGS
USAGE=$?
if [[ $USAGE -eq 0 ]] ; then
  usage
  exit
fi

find_path $ALL_ARGS 
list_contains_count obs $ALL_ARGS
#shift

REST_ARGS=$*

find_optval "--rev=" $REST_ARGS
OK=$?
set -x
if [[ $OK -eq 0 ]]; then
  REVSTRING="-r $OPTVAL"
else
  REVSTRING=""
fi
set +x 

VERSION=$(sh version.sh $DOOBLE_SRC_ROOT)
find_optval "--version=" $REST_ARGS
OK=$?
if [[ $OK -eq 0 ]]; then
  VERSION=$OPTVAL
fi

PROJECT=dooble
NAME=${PROJECT}
CHANGELOG=${NAME}.changes
DEBIAN_TEMP_DIR=${NAME}.orig

  set -x
  cd $DOOBLE_SRC_ROOT

  set +x

echo "version is " $VERSION

ARCHIVE=${NAME}-${VERSION}
DEBIAN_ARCHIVE=${NAME}_${VERSION}
TARFILE=${DEBIAN_ARCHIVE}.tar.gz
DEBIAN_TARFILE=${TARFILE}
DEBIAN_DSCFILE=${DEBIAN_ARCHIVE}.dsc
DEBIAN_PACKDIR=${ORIGIN}/debian_packaging
DEBIAN_DIFF=${DEBIAN_ARCHIVE}.diff.gz


#pack_archive ${ARCHIVE}/ ${TARFILE}

###
### pack archive from svn
###


  
  TN=`mktemp -d /tmp/dooble_XXXXXXXX`

  PREFIX=${PROJECT}-${VERSION}
  DEB_PREFIX=${PROJECT}_${VERSION}
  TARFILE=${DEB_PREFIX}.tar.gz

  TP=${TN}/${DEB_PREFIX}
  TPNOSLASH=${TP:1}

  set -x
  svn export ${REVSTRING} . ${TP}
  set +x

  mkdir -p ${TP}/debian
  cp  ${ORIGIN}/debian/* ${TP}/debian

  FILES="\
      dooble.desktop \
      dooble.pro \
      dooble.sh \
      dooble.*.pro \
      debian \
      Icons \
      Images \
      Include \
      Include.win \
      Libraries.win \
      Plugins \
      Packaging \
      Resources \
      Source \
      Tab \
      Translations \
      UI \
      plugin-spec \
      "

  ( 
      set -x
      cd ${TP} 
      tar  \
          --transform="s+^+${PREFIX}/+"  \
          --exclude='*.dll' \
          --exclude='*.exe' \
          --exclude='*.a' \
          --exclude='*.so' \
          -zcf  ${ORIGIN}/${TARFILE} \
          ${FILES}
      set +x
  )
  cd ${ORIGIN}

  rm -rf ${TN}
  echo "created ${TARFILE}"
  ls -l ${TARFILE}



### done packing
###

TEMPDIR=build_${NAME}_${VERSION}

(
  set -x
  mkdir -p $TEMPDIR
  cp $TARFILE $TEMPDIR
  cd $TEMPDIR

  tar zxf $TARFILE
  dpkg-source -b ${ARCHIVE}
  set +x
)

RPM_PACKDIR=${ORIGIN}/rpm_packaging
RPM_TARFILE=${DEBIAN_TARFILE}

WANT_OBS=$LIST_COUNT
echo "WANT_OSC is $WANT_OBS"

DEB_FILES=" \
          ${TEMPDIR}/$DEBIAN_TARFILE \
           ${TEMPDIR}/$DEBIAN_DSCFILE \
          "

set -x
mkdir -p ${DEBIAN_PACKDIR}
cp ${DEB_FILES} ${DEBIAN_PACKDIR}

cp ${TEMPDIR}/${DEBIAN_TARFILE} ${CHANGELOG} ${RPM_PACKDIR}
(
  set -x
  cd ${RPM_PACKDIR}
  make spec
  set +x
)

if [ 0$WANT_OBS -ge 1 ]; then
  #cp $DEB_FILES meego_obs/
  echo "obs copy: "
  for OBS_DIR in suse_obs ; do
    echo "Copy -------> " ${OBS_DIR}
    set -x
    cp ${DEB_FILES} \
       ${RPM_PACKDIR}/${NAME}.spec \
       ${RPM_PACKDIR}/${NAME}.changes \
       ${OBS_DIR}
    set +x
  done
fi
echo ${VERSION} > ${RPM_PACKDIR}/pack-version
echo ${NAME} > ${RPM_PACKDIR}/pack-name


set +x

DEFAULT_REMOVE="n"

echo -n " remove ${TEMPDIR} [${DEFAULT_REMOVE}] "
read YORN

if [ "X$YORN" == "XY" ]; then
  set -x
  rm -rf ${TEMPDIR} 
  set +x
fi
if [ "X$YORN" == "Xy" ]; then
  set -x
  rm -rf ${TEMPDIR} 
  set +x
fi

