#include <stdio.h>
#include <stdlib.h>

#include "libspoton.h"

int main(void)
{
  libspoton_error_t rc = LIBSPOTON_ERROR_NONE;
  libspoton_handle_t libspotonHandle;

  if((rc = libspoton_init("shared.db",
			  &libspotonHandle)) != 0)
    printf("libspoton_init() error (%d).\n", rc);

  if((rc = libspoton_generate_private_public_keys("0123456789",
						  "aes256",
						  1024,
						  &libspotonHandle)) != 0)
    printf("libspoton_generate_private_public_keys() error (%d).\n", rc);

  libspoton_close(&libspotonHandle);

  if((rc = libspoton_init("shared.db",
			  &libspotonHandle)) != 0)
    printf("libspoton_init() error (%d).\n", rc);

  if((rc = libspoton_populate_public_key(&libspotonHandle)) != 0)
    printf("libspoton_populate_public_key() error (%d).\n", rc);

  const char *description = "Dooble";
  const char *title = "Dooble Web Browser";
  const char *url = "http://dooble.sourceforge.net";

  if((rc = libspoton_save_url(url,
			      title,
			      description,
			      &libspotonHandle)) != 0)
    printf("libspoton_save_url() error (%d).\n", rc);

  libspoton_close(&libspotonHandle);
  return EXIT_SUCCESS;
}
