#ifndef LIBSPOTON_H
#define LIBSPOTON_H

#include <errno.h>
#include <gcrypt.h>
#include <pthread.h>
#ifdef LIBSPOTON_OS_WINDOWS
#include "sqlite3.h"
#else
#include <sqlite3.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum
  {
    LIBSPOTON_ERROR_NONE = 0,
    LIBSPOTON_ERROR_GCRY_CALLOC_SECURE,
    LIBSPOTON_ERROR_GCRY_CHECK_VERSION,
    LIBSPOTON_ERROR_GCRY_CIPHER_ENCRYPT,
    LIBSPOTON_ERROR_GCRY_CIPHER_GET_ALGO_BLKLEN,
    LIBSPOTON_ERROR_GCRY_CIPHER_GET_ALGO_KEYLEN,
    LIBSPOTON_ERROR_GCRY_CIPHER_OPEN,
    LIBSPOTON_ERROR_GCRY_CIPHER_SETIV,
    LIBSPOTON_ERROR_GCRY_CIPHER_SETKEY,
    LIBSPOTON_ERROR_GCRY_CONTROL,
    LIBSPOTON_ERROR_GCRY_PK_ENCRYPT_DESCRIPTION,
    LIBSPOTON_ERROR_GCRY_PK_ENCRYPT_TITLE,
    LIBSPOTON_ERROR_GCRY_PK_ENCRYPT_URL,
    LIBSPOTON_ERROR_GCRY_PK_GENKEY,
    LIBSPOTON_ERROR_GCRY_SEXP_FIND_TOKEN_PRIVATE_KEY,
    LIBSPOTON_ERROR_GCRY_SEXP_FIND_TOKEN_PUBLIC_KEY,
    LIBSPOTON_ERROR_GCRY_SEXP_BUILD,
    LIBSPOTON_ERROR_GCRY_SEXP_BUILD_DESCRIPTION,
    LIBSPOTON_ERROR_GCRY_SEXP_BUILD_TITLE,
    LIBSPOTON_ERROR_GCRY_SEXP_BUILD_URL,
    LIBSPOTON_ERROR_GCRY_SEXP_NEW,
    LIBSPOTON_ERROR_GCRY_SEXP_SPRINT_DESCRIPTION,
    LIBSPOTON_ERROR_GCRY_SEXP_SPRINT_PRIVATE_KEY,
    LIBSPOTON_ERROR_GCRY_SEXP_SPRINT_PUBLIC_KEY,
    LIBSPOTON_ERROR_GCRY_SEXP_SPRINT_TITLE,
    LIBSPOTON_ERROR_GCRY_SEXP_SPRINT_URL,
    LIBSPOTON_ERROR_MALLOC,
    LIBSPOTON_ERROR_NULL_LIBSPOTON_HANDLE,
    LIBSPOTON_ERROR_SQLITE_BIND_BLOB,
    LIBSPOTON_ERROR_SQLITE_BIND_BLOB_DESCRIPTION,
    LIBSPOTON_ERROR_SQLITE_BIND_BLOB_TITLE,
    LIBSPOTON_ERROR_SQLITE_BIND_BLOB_URL,
    LIBSPOTON_ERROR_SQLITE_BIND_TEXT,
    LIBSPOTON_ERROR_SQLITE_COLUMN_TEXT,
    LIBSPOTON_ERROR_SQLITE_CREATE_KEYS_TABLE,
    LIBSPOTON_ERROR_SQLITE_CREATE_KEYS_TRIGGER,
    LIBSPOTON_ERROR_SQLITE_CREATE_URLS_TABLE,
    LIBSPOTON_ERROR_SQLITE_OPEN_V2,
    LIBSPOTON_ERROR_SQLITE_PREPARE_V2,
    LIBSPOTON_ERROR_SQLITE_STEP
  }
  libspoton_error_code_t;

struct libspoton_handle_struct_t
{
  sqlite3 *sqliteHandle;
  gcry_sexp_t publicKey;
};

typedef libspoton_error_code_t libspoton_error_t;
typedef struct libspoton_handle_struct_t libspoton_handle_t;

/*
** Generate a new private and public key pair. Please note that
** publicKey is destroyed if it is non-zero before being populated
** with a new value.
*/

libspoton_error_t libspoton_generate_private_public_keys
(const char *passphrase,
 const char *cipher,
 const int nbits,
 libspoton_handle_t *libspotonHandle);

/*
** Create shared.db. Initialize publicKey to zero.
*/

libspoton_error_t libspoton_init(const char *databasePath,
				 libspoton_handle_t *libspotonHandle);

/*
** Extract the public_key from the keys table and place the S-expression
** into publicKey.
*/

libspoton_error_t libspoton_populate_public_key
(libspoton_handle_t *libspotonHandle);

/*
** Encode the description, title, and url and place the encoded
** forms into the urls table.
*/

libspoton_error_t libspoton_save_url(const char *url,
				     const char *title,
				     const char *description,
				     libspoton_handle_t *libspotonHandle);

/*
** Release resources and reset publicKey to zero.
*/

void libspoton_close(libspoton_handle_t *libspotonHandle);

#endif
