/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dmisc_h_
#define _dmisc_h_

extern "C"
{
  /*
  ** Older compilers (GCC 4.2.1) misbehave.
  */

#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#include <gcrypt.h>
#pragma GCC diagnostic warning "-Wdeprecated-declarations"
}

#include <QDir>
#include <QPair>
#include <QUuid>

#include "dtypes.h"

class QUrl;
class QIcon;
class QRect;
class QMutex;
class QProgressBar;
class QNetworkProxy;

class dmisc
{
 public:
  static int levenshteinDistance(const QString &str1,
				 const QString &str);
  static QUrl correctedUrlPath(const QUrl &url);
  static bool isKDE(void);
  static bool isGnome(void);
  static bool isHashTypeSupported(const QString &hashType);
  static bool isCipherTypeSupported(const QString &cipherType);
  static bool passphraseWasPrepared(void);
  static bool canDoobleOpenLocalFile(const QUrl &url);
  static bool isSchemeAcceptedByDooble(const QString &scheme);
  static bool passphraseWasAuthenticated(void);
  static void logError(const QString &error);
  static void destroyCrypt(void);
  static void clearFavicons(void);
  static void saveIconForUrl(const QIcon &icon, const QUrl &url);
  static void initializeCrypt(void);
  static void reencodeFavicons(QProgressBar *progress);
  static void launchApplication(const QString &program,
				const QStringList &arguments);
  static void purgeTemporaryData(void);
  static void prepareFaviconsList(void);
  static void setCipherPassphrase(const QString &passphrase, const bool save,
				  const QString &hashType,
				  const QString &cipherType,
				  const int iterationCount);
  static void removeRestorationFiles(const QUuid &id = QUuid());
  static void removeRestorationFiles(const QUuid &pid, const qint64 wid);
  static void setActionForFileSuffix(const QString &suffix,
				     const QString &action);
  static QIcon iconForUrl(const QUrl &url);
  static QIcon iconForFileSuffix(const QString &suffix);
  static QRect balancedGeometry(const QRect &geometry,
				QWidget *widget);
  static qint64 faviconsSize(void);
  static QString formattedSize(const qint64 fileSize);
  static QString passphraseHash(const QString &passphrase,
				const QString &salt,
				const QString &hashType);
  static QString elidedTitleText(const QString &text);
  static QString fileNameFromUrl(const QUrl &url);
  static QString findUniqueFileName(const QString &fileName,
				    const QDir &path = QDir());
  static QByteArray hashedString(const QByteArray &byteArray);
  static QByteArray decodedString(const QByteArray &byteArray);
  static QByteArray encodedString(const QByteArray &byteArray,
				  const bool shouldEncode);
  static QStringList hashTypes(void);
  static QStringList cipherTypes(void);
  static QNetworkProxy proxyByUrl(const QUrl &url);
  static QNetworkProxy proxyByFunctionAndUrl
    (const DoobleDownloadType::DoobleDownloadTypeEnum functionType,
     const QUrl &url);

 private:
  dmisc(void);
  static int s_algorithm;
  static bool s_cryptOK;
  static bool s_passphraseWasAuthenticated;
  static char *s_passphraseHash;
  static size_t s_passphraseHashLength;
  static QMutex s_cipherMutex;
  static gcry_cipher_hd_t s_cipherCtx;
  static QList<QPair<QUrl, QIcon> > s_faviconsList; /*
						    ** Used during re-encoding.
						    */
  static gcry_error_t setKey(char *passphrase, const size_t passphraseLength,
			     const bool isRandomPassphrase);
  static gcry_error_t setInitializationVector(QByteArray &bytes);
};

#endif
