/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dbookmarkswindow_h_
#define _dbookmarkswindow_h_

#include <QPointer>
#include <QMainWindow>

#include "ui_bookmarksWindow.h"

class QAction;
class QProgressBar;
class QStandardItem;
class QStandardItemModel;

class dbookmarkswindow: public QMainWindow
{
  Q_OBJECT

 public:
  dbookmarkswindow(void);
  ~dbookmarkswindow();
  bool isBookmarked(const QUrl &url) const;
  void show(QWidget *parent);
  void populate(void);
  void reencode(QProgressBar *progress);
  void addFolder(void);
  void renameFolder(const QModelIndex &index);
  void prepareBookmarksList(void);
  qint64 size(void) const;
  QList<QAction *> actions(QWidget *parent) const;

 private:
  QPointer<QWidget> m_parent;
  Ui_bookmarksWindow ui;
  QStandardItemModel *m_urlModel;
  QList<QVariantList> m_bookmarksList;
  QUrl titleChanged(void) const;
  QUrl locationChanged(void) const;
  void purge(void);
  void saveState(void);
  void closeEvent(QCloseEvent *event);
  void saveFolder(QStandardItem *item);
  void updateFolder(const QString &name,
		    const int oid);
  void keyPressEvent(QKeyEvent *event);
  void populateTable(void);
  void populateTable(const int folderOid);
  void updateBookmark(const QUrl &originalUrl);
  void createBookmarksDatabase(void);

 public slots:
  void slotSetIcons(void);
  void slotAddBookmark(const QUrl &url,
		       const QIcon &icon,
		       const QString &title,
		       const QString &description,
		       const QDateTime &addDate,
		       const QDateTime &lastModified);

 private slots:
  void slotOpen(void);
  void slotSort(int column, Qt::SortOrder order);
  void slotExport(void);
  void slotImport(void);
  void slotCopyUrl(void);
  void slotRefresh(void);
  void slotAddFolder(void);
  void slotTextChanged(const QString &text);
  void slotUrlSelected(const QItemSelection &selected,
		       const QItemSelection &deselected);
  void slotDeleteFolder(void);
  void slotOpenInNewTab(void);
  void slotTitleChanged(void);
  void slotTitleChanged(const int folderOid,
			const QUrl &url,
			const QString &title);
  void slotDeleteBookmark(void);
  void slotFolderSelected(const QModelIndex &index);
  void slotAboutToHideMenu(void);
  void slotAboutToShowMenu(void);
  void slotBookmarkDeleted(const int folderOid,
			   const QUrl &url);
  void slotLocationChanged(void);
  void slotOpenInNewWindow(void);
  void slotParentDestroyed(void);
  void slotShowContextMenu(const QPoint &point);
  void slotBookmarkReceived(const QModelIndex &index);
  void slotFolderDataChanged(const QModelIndex &topLeft,
			     const QModelIndex &bottomRight);
  void slotItemDoubleClicked(const QModelIndex &index);
  void slotAddFolderOffParent(void);
  void slotDescriptionChanged(void);

 signals:
  void open(const QUrl &url);
  void changed(void);
  void createTab(const QUrl &url);
  void iconsChanged(void);
  void openInNewWindow(const QUrl &url);
};

#endif
