/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dftpbrowser_h_
#define _dftpbrowser_h_

#include <QUrl>
#include <QPointer>
#include <QTableWidget>

#include "ui_ftpManagerForm.h"

class QWebPage;
class QWebFrame;

class dftp;
class dftpfileinfo;

class dftpbrowser: public QWidget
{
  Q_OBJECT

 public:
  dftpbrowser(QWidget *parent);
  ~dftpbrowser();
  QUrl url(void) const;
  void load(const QUrl &url, QPointer<dftp> ftp);
  void stop(void);
  QString html(void) const;
  QString title(void) const;
  QString statusMessage(void) const;
  QWebFrame *mainFrame(void) const;

 private:
  int m_fileCount;
  int m_directoryCount;
  QUrl m_url;
  QUrl m_selectedUrl;
  QWebPage *m_webPage;
  QPointer<dftp> m_ftp;
  Qt::MouseButton m_lastButtonPressed;
  Ui_ftpManagerForm ui;
  void mousePressEvent(QMouseEvent *event);

 private slots:
  void slotFinished(const bool ok);
  void slotSaveLink(void);
  void slotListInfos(const QList<dftpfileinfo> &info);
  void slotUrlChanged(const QUrl &url);
  void slotItemClicked(QTableWidgetItem *item);
  void slotAppendMessage(const QString &text);
  void slotCopyLinkLocation(void);
  void slotOpenLinkInNewTab(void);
  void slotUnsupportedContent(const QUrl &url);
  void slotOpenLinkInNewWindow(void);
  void slotSaveTableHeaderState(void);
  void slotCustomContextMenuRequest(const QPoint &point);

 signals:
  void saveUrl(const QUrl &url);
  void copyLink(const QUrl &url);
  void loadPage(const QUrl &url);
  void urlChanged(const QUrl &url);
  void iconChanged(void);
  void loadStarted(void);
  void loadFinished(bool ok);
  void loadProgress(int progress);
  void titleChanged(const QString &title);
  void openLinkInNewTab(const QUrl &url);
  void unsupportedContent(const QUrl &url);
  void openLinkInNewWindow(const QUrl &url);
  void statusMessageReceived(const QString &message);
};

#endif
