/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _ddownloadwindowitem_h_
#define _ddownloadwindowitem_h_

#include <QUrl>
#include <QTime>
#include <QString>
#include <QWidget>
#include <QPointer>
#include <QDateTime>
#include <QNetworkProxy>

#include "ui_downloadWindowItem.h"

class QNetworkReply;
class QAuthenticator;
class QNetworkAccessManager;

class ddownloadwindowitem: public QWidget
{
  Q_OBJECT

 public:
  ddownloadwindowitem(QWidget *parent);
  ~ddownloadwindowitem();
  int choice(void) const;
  bool abortedByUser(void) const;
  bool isDownloading(void) const;
  QUrl url(void) const;
  void downloadUrl(const QUrl &url, const QString &fileName,
		   const bool isNew,
		   const QDateTime &dateTime,
		   const int choice);
  void downloadFile(const QString &srcFileName, const QString &dstFileName,
		    const bool isNew, const QDateTime &dateTime);
  void downloadHtml(const QString &html, const QString &dstFileName);
  QString text(void) const;
  QString fileName(void) const;
  QDateTime dateTime(void) const;

 private:
  int m_rate;
  int m_choice;
  bool m_paused;
  bool m_abortedByUser;
  QUrl m_url;
  QTime m_lastTime;
  qint64 m_total;
  qint64 m_lastSize;
  QString m_html;
  QString m_dstFileName;
  QString m_srcFileName;
  QDateTime m_dateTime;
  Ui_downloadWindowItem ui;
  QPointer<QNetworkAccessManager> m_networkAccessManager;
  void updateProgress(const qint64 done, const qint64 total);
  void downloadFinished(const qint64 fileSize);
  void init_ddownloadwindowitem(void);

 public slots:
  void slotSetIcons(void);

 private slots:
  void slotReadyRead(void);
  void slotAbortDownload(void);
  void slotDownloadAgain(void);
  void slotPauseDownload(void);
  void slotMetaDataChanged(void);
  void slotDownloadFinished(void);
  void slotDataTransferProgress(qint64 done, qint64 total);

 signals:
  void recordDownload(const QString &fileName,
		      const QUrl &url,
		      const QDateTime &dateTime);
  void downloadFinished(void);
  void authenticationRequired(QNetworkReply *reply,
			      QAuthenticator *authenticator);
  void proxyAuthenticationRequired(const QNetworkProxy &proxy,
				   QAuthenticator *authenticator);
};

#endif
