/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#include <QMouseEvent>
#include <QNetworkProxy>
#include <QNetworkReply>
#include <QWebHitTestResult>
#include <QWebElementCollection>
#ifdef DOOBLE_USE_QGRAPHICSWEBVIEW
#include <QGraphicsSceneMouseEvent>
#endif

#include "dmisc.h"
#include "dooble.h"
#include "dwebview.h"

#ifndef DOOBLE_USE_QGRAPHICSWEBVIEW
dwebview::dwebview(QWidget *parent):QWebView(parent)
#else
dwebview::dwebview(QGraphicsItem *parent):QGraphicsWebView(parent)
#endif
{
  m_allowPopup = false;
  m_lastButtonPressed = Qt::NoButton;
  connect(this,
	  SIGNAL(loadStarted(void)),
	  this,
	  SLOT(slotLoadStarted(void)));
#ifdef DOOBLE_USE_QGRAPHICSWEBVIEW
  setFocusPolicy(Qt::StrongFocus);
  setWindowFlags(Qt::FramelessWindowHint);
#endif
}

bool dwebview::checkAndClearPopup(void)
{
  bool allowPopup = m_allowPopup;

  m_allowPopup = false;
  return allowPopup;
}

#ifndef DOOBLE_USE_QGRAPHICSWEBVIEW
void dwebview::mousePressEvent(QMouseEvent *event)
#else
void dwebview::mousePressEvent(QGraphicsSceneMouseEvent *event)
#endif
{
  /*
  ** We use this method to determine valid popups.
  */

  m_allowPopup = false;

  if(event)
    {
      m_lastButtonPressed = event->button();

      QWebFrame *frame = page()->currentFrame();

      if(frame)
	{
	  QWebHitTestResult hit = frame->hitTestContent
#ifndef DOOBLE_USE_QGRAPHICSWEBVIEW
	    (event->pos());
#else
	    (event->pos().toPoint());
#endif

	  if(hit.linkUrl().isValid())
	    m_allowPopup = true;
	  else if(!hit.isNull())
	    {
	      bool found = false;
	      QWebElementCollection collection = frame->
		documentElement().findAll("input[type=button]");

	      foreach(QWebElement element, collection)
		{
		  if(element == hit.element())
		    {
		      found = true;
		      break;
		    }
		}

	      if(!found)
		{
		  collection = frame->
		    documentElement().findAll("input[type=image]");

		  foreach(QWebElement element, collection)
		    {
		      if(element == hit.element())
			{
			  found = true;
			  break;
			}
		    }
		}

	      if(!found)
		{
		  collection = frame->
		    documentElement().findAll("input[type=submit]");

		  foreach(QWebElement element, collection)
		    {
		      if(element == hit.element())
			{
			  found = true;
			  break;
			}
		    }
		}

	      if(found)
		m_allowPopup = true;
	      else
		{
		  foreach(QWebElement element, frame->documentElement().
			  findAll("*"))
		    if(element.geometry().contains(hit.pos()))
		      {
			if(element.attribute("role").toLower() == "link" ||
			   element.attribute("method").toLower() == "post" ||
			   element.hasAttribute("href") ||
			   element.hasAttribute("onclick") ||
			   (element.hasAttribute("id") &&
			    QUrl(element.attribute("id")).isValid()) ||
			   (element.hasAttribute("src") &&
			    QUrl(element.attribute("src")).isValid()))
			  {
			    found = true;
			    break;
			  }
		      }

		  if(found)
		    m_allowPopup = true;
		}
	    }
	}
    }

#ifndef DOOBLE_USE_QGRAPHICSWEBVIEW
  QWebView::mousePressEvent(event);
#else
  QGraphicsWebView::mousePressEvent(event);
#endif
}

Qt::MouseButton dwebview::mouseButtonPressed(void) const
{
  return m_lastButtonPressed;
}

void dwebview::slotLoadStarted(void)
{
  m_lastButtonPressed = Qt::NoButton;
}
