/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dsettings_h_
#define _dsettings_h_

#include <QTimer>
#include <QPointer>
#include <QMainWindow>

#include "ui_settings.h"

class dooble;
class QKeyEvent;

class dsettings: public QMainWindow
{
  Q_OBJECT

 public:
  dsettings(void);
  ~dsettings();
  void exec(dooble *parent);
  dooble *parentDooble(void) const;

 private:
  QTimer m_updateCacheLabelTimer;
  QTimer m_purgeMemoryCachesTimer;
  QString m_previousIconSet;
  QPointer<dooble> m_parentDooble;
  Ui_settingsWindow ui;
  void closeEvent(QCloseEvent *event);
  void keyPressEvent(QKeyEvent *event);
  void updateFontWidgets(const QString &fontName, QComboBox *fontSizeWidget);

 public slots:
  void slotPopulateApplications(const QMap<QString, QString> &suffixes);
  void slotPassphraseWasAuthenticated(const bool state);

 private slots:
  void slotClicked(QAbstractButton *button);
  void slotSetIcons(void);
  void slotChangePage(bool checked);
  void slotDeleteSuffix(void);
  void slotIconsPreview(void);
  void slotClearFavicons(void);
  void slotClearDiskCache(void);
  void slotWebFontChanged(const QString &text);
  void slotGroupBoxClicked(bool checked);
  void slotClearMemoryCache(void);
  void slotEnablePassphrase(void);
  void slotUpdateCacheLabel(void);
  void slotCacheValueChanged(int value);
  void slotPurgeMemoryCaches(void);
  void slotSelectIconCfgFile(void);
  void slotUpdateApplication(const QString &suffix, const QString &action);
  void slotCookieTimerTimeChanged(int index);
  void slotCustomContextMenuRequested(const QPoint &point);
  void slotApplicationPulldownActivated(int index);
  void slotChooseMyRetrievedFilesDirectory(void);

 signals:
  void showTabBar(const bool state);
  void iconsChanged(void);
  void settingsReset(void);
  void showIpAddress(const bool state);
  void diskCacheEnabled(const bool state);
  void cookieTimerChanged(void);
  void reencodeRestorationFile(void);
  void textSizeMultiplierChanged(const qreal multiplier);
};

#endif
