/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009, 2010, 2011, 2012 Alexis Megas,
** Gunther van Dooble, and the Dooble Team.
** All rights reserved.
**
** License: GPL2 only:
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://sf.net/projects/dooble
**   http://dooble.sf.net
****************************************************************************/

#ifndef _dnetworkaccessmanager_h_
#define _dnetworkaccessmanager_h_

#include <QPointer>
#include <QNetworkReply>
#include <QNetworkAccessManager>

class QNetworkRequest;

class dftp;
class dexceptionswindow;

class dnetworkdirreply: public QNetworkReply
{
  Q_OBJECT

 public:
  /*
  ** qRegisterMetaType() requires a public default contructor,
  ** a public copy constructor, and a public destructor.
  */

  dnetworkdirreply(void):QNetworkReply(0)
  {
  }

  dnetworkdirreply(const dnetworkdirreply &reply):QNetworkReply(0)
  {
    setUrl(reply.url());
    setRequest(reply.request());
    setOperation(reply.operation());
  }

  ~dnetworkdirreply()
  {
  }

  dnetworkdirreply(QObject *parent, const QUrl &url);
  bool isSequential(void) const;
  void load(void);
  void abort(void);
  qint64 bytesAvailable(void) const;

 protected:
  qint64 readData(char *data, qint64 maxSize);

 signals:
  void finished(dnetworkdirreply *reply);
};

class dnetworkerrorreply: public QNetworkReply
{
  Q_OBJECT

 public:
  /*
  ** qRegisterMetaType() requires a public default contructor,
  ** a public copy constructor, and a public destructor.
  */

  dnetworkerrorreply(void):QNetworkReply(0)
  {
  }

  dnetworkerrorreply(const dnetworkerrorreply &reply):QNetworkReply(0)
  {
    setUrl(reply.url());
    setRequest(reply.request());
    setOperation(reply.operation());
  }

  ~dnetworkerrorreply()
  {
  }

  dnetworkerrorreply(QObject *parent, const QNetworkRequest &request);
  bool isSequential(void) const;
  void load(void);
  void abort(void);
  qint64 bytesAvailable(void) const;
  QByteArray html(void) const;

 private:
  QByteArray m_content;

 protected:
  qint64 readData(char *data, qint64 maxSize);

 signals:
  void finished(dnetworkerrorreply *reply);
};

class dnetworkftpreply: public QNetworkReply
{
  Q_OBJECT

 public:
  /*
  ** qRegisterMetaType() requires a public default contructor,
  ** a public copy constructor, and a public destructor.
  */

  dnetworkftpreply(void):QNetworkReply(0)
  {
  }

  dnetworkftpreply(const dnetworkftpreply &reply):QNetworkReply(0)
  {
    setUrl(reply.url());
    setRequest(reply.request());
    setOperation(reply.operation());
  }

  ~dnetworkftpreply()
  {
  }

  dnetworkftpreply(QObject *parent, const QUrl &url);
  bool isSequential(void) const;
  void load(void);
  void abort(void);
  qint64 bytesAvailable(void) const;
  QPointer<dftp> ftp(void) const;

 private:
  QPointer<dftp> m_ftp;

 protected:
  qint64 readData(char *data, qint64 maxSize);

 private slots:
  void slotFtpFinished(bool ok);
  void slotUnsupportedContent(const QUrl &url);

 signals:
  void finished(dnetworkftpreply *reply);
};

class dnetworkaccessmanager: public QNetworkAccessManager
{
  Q_OBJECT

 public:
  dnetworkaccessmanager(QObject *parent);
  QNetworkReply *createRequest(Operation op,
			       const QNetworkRequest &req,
			       QIODevice *outgoingData = 0);

 private slots:
  void slotFinished(QNetworkReply *reply);

 signals:
  void finished(dnetworkdirreply *reply);
  void finished(dnetworkftpreply *reply);
  void finished(dnetworkerrorreply *reply);
  void doNotTrack(const QString &host,
		  const QUrl &url,
		  const QDateTime &dateTime);
  void loadStarted(void);
  void exceptionRaised(dexceptionswindow *window,
		       const QUrl &url);
  void loadImageRequest(const QString &host,
			const QUrl &url,
			const QDateTime &dateTime);
  void blockThirdPartyHost(const QString &host,
			   const QUrl &url,
			   const QDateTime &dateTime);
  void suppressHttpReferrer(const QString &host,
			    const QUrl &url,
			    const QDateTime &dateTime);
  void urlRedirectionRequest(const QString &host,
			     const QUrl &url,
			     const QDateTime &dateTime);
};

#endif
