"""
@todo Remove blocking operations from UI thread
"""

import webbrowser
import base64

import common_view

import gtk_toolbox
import rtm_backend
import cache_backend
import rtm_api


def get_token(username, apiKey, secret):
	token = None
	rtm = rtm_api.RTMapi(username, apiKey, secret, token)

	authURL = rtm.getAuthURL()
	webbrowser.open(authURL)
	mb = gtk_toolbox.MessageBox2("You need to authorize DoneIt with\nRemember The Milk.\nClick OK after you authorize.")
	mb.run()

	token = rtm.getToken()
	return token


def get_credentials(credentialsDialog):
	# @todo Pass in parent window
	username, password = credentialsDialog.request_credentials()
	token = get_token(username, rtm_backend.RtmBackend.API_KEY, rtm_backend.RtmBackend.SECRET)
	return username, password, token


class RtmView(common_view.CommonView):

	def __init__(self, widgetTree, errorDisplay):
		super(RtmView, self).__init__(widgetTree, errorDisplay)
		self._credentials = "", "", ""
		self._credentialsDialog = gtk_toolbox.LoginWindow(widgetTree)

	@staticmethod
	def name():
		return "Remember The Milk"

	def load_settings(self, config):
		"""
		@note Thread Agnostic
		"""
		blobs = (
			config.get(self.name(), "bin_blob_%i" % i)
			for i in xrange(len(self._credentials))
		)
		creds = (
			base64.b64decode(blob)
			for blob in blobs
		)
		self._credentials = tuple(creds)

	def save_settings(self, config):
		"""
		@note Thread Agnostic
		"""
		config.add_section(self.name())
		for i, value in enumerate(self._credentials):
			blob = base64.b64encode(value)
			config.set(self.name(), "bin_blob_%i" % i, blob)

	def login(self):
		"""
		@note UI Thread
		"""
		if self._manager is not None:
			return

		credentials = self._credentials
		while True:
			try:
				self._manager = rtm_backend.RtmBackend(*credentials)
				self._manager = cache_backend.LazyCacheBackend(self._manager)
				self._credentials = credentials
				return # Login succeeded
			except rtm_api.AuthStateMachine.NoData:
				# Login failed, grab new credentials
				credentials = get_credentials(self._credentialsDialog)

	def logout(self):
		"""
		@note Thread Agnostic
		"""
		self._credentials = "", "", ""
		self._manager = None
