class NullBackend(object):

	def __init__(self, username, password, token=None):
		pass

	def save(self):
		pass

	def load(self):
		pass

	def add_project(self, name):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_project_name(self, projId, name):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_project_visibility(self, projId, visibility):
		raise NotImplementedError("Not logged in to any ToDo system")

	def get_projects(self):
		return []

	def get_project(self, projId):
		raise NotImplementedError("Not logged in to any ToDo system")

	def lookup_project(self, projName):
		raise NotImplementedError("Not logged in to any ToDo system")

	def get_locations(self):
		return []

	def get_tasks_with_details(self, projId):
		return []

	def get_task_details(self, taskId):
		raise NotImplementedError("Not logged in to any ToDo system")

	def add_task(self, projId, taskName):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_project(self, taskId, newProjId):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_name(self, taskId, name):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_duedate(self, taskId, dueDate):
		raise NotImplementedError("Not logged in to any ToDo system")

	def set_priority(self, taskId, priority):
		raise NotImplementedError("Not logged in to any ToDo system")

	def complete_task(self, taskId):
		raise NotImplementedError("Not logged in to any ToDo system")

	def add_note(self, taskId, noteTitle, noteBody):
		raise NotImplementedError("Not logged in to any ToDo system")

	def update_note(self, noteId, noteTitle, noteBody):
		raise NotImplementedError("Not logged in to any ToDo system")

	def delete_note(self, noteId):
		raise NotImplementedError("Not logged in to any ToDo system")
