"""
@todo Remove blocking operations from UI thread
"""

import common_view

import gtk_toolbox
import file_backend


class FileView(common_view.CommonView):

	def __init__(self, widgetTree, errorDisplay, defaultPath):
		super(FileView, self).__init__(widgetTree, errorDisplay)
		self._path = defaultPath

	@staticmethod
	def name():
		return "File"

	def load_settings(self, config):
		"""
		@note Thread Agnostic
		"""
		path = config.get(self.name(), "path")
		if path is not None:
			self._path

	def save_settings(self, config):
		"""
		@note Thread Agnostic
		"""
		self._manager.save()
		config.add_section(self.name())
		config.set(self.name(), "path", self._path)

	def login(self):
		"""
		@note UI Thread
		"""
		if self._manager is not None:
			return

		self._manager = file_backend.FileBackend(self._path)
		self._manager.load()

	def logout(self):
		"""
		@note Thread Agnostic
		"""
		self._manager.save()
		self._manager = None
