/*
  DiskUsage - shows the disk usage under a number of operating systems.
  Copyright (C) 2004  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/Path.h>

#include <Lum/Dlg/ActionDialog.h>
#include <Lum/Dlg/Progress.h>

class DirEntry
{
public:
  Lum::Base::Path                  path;
  double                           size;
  std::map<std::wstring,DirEntry*> subDirs;

public:
  DirEntry(const Lum::Base::Path& path);
  ~DirEntry();

  void AccumulateSize();
};

class MapWindow : public Lum::Dlg::ActionDialog
{
private:
  DirEntry *top;
  double   size;

public:
  MapWindow(DirEntry *top, double size);

  Lum::Object* GetContent();

  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

class ScanTask : public Lum::Dlg::ProgressTask
{
private:
  Lum::Base::Path dir;

public:
  DirEntry        *top;
  double          size;

public:
  ScanTask();

  void SetSize(double size);

  void SetDir(const Lum::Base::Path& dir);

  void Run();
};

