#include "dclocksettings.h"
#include <QSettings>
#include <QVariant>

/*It's better to use QCoreApplication::setOrganizationName(), QCoreApplication::setOrganizationDomain(),
and QCoreApplication::setApplicationName(). And then only use QSettings() in any place.
But this solution is based on incapsulation strategy, and therefore if this code become a part of lib
and will be used in app without setted appropriate values for application and organization names, then it would probably
 cause some problems */

static const QString organizationName = QString("Avis");
static const QString applicationName = QString("DigiClock");


//get widget size;
QSize dclocksettings::getSize() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    int wdth = sett.value("WidgetWidth",300).toInt();
    int hgth = sett.value("WidgetHeight",80).toInt();

    return QSize(wdth, hgth);
}

//set widget size;
void dclocksettings::setSize(const QSize &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("WidgetWidth",aSize.width());
    sett.setValue("WidgetHeight",aSize.height());
}

//get color of digits
QColor dclocksettings::getColor() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    int r = sett.value("DigitsColorR",255).toInt();
    int g = sett.value("DigitsColorG",255).toInt();
    int b = sett.value("DigitsColorB",255).toInt();
    int a = sett.value("DigitsColorA",255).toInt();
    return QColor(r,g,b,a);
}

//set color of digits
void dclocksettings::setColor(const QColor &aColor) const
{
    QSettings sett(organizationName,applicationName);
    int r = aColor.red();
    int g = aColor.green();
    int b = aColor.blue();
    int a = aColor.alpha();
    sett.setValue("DigitsColorR",r);
    sett.setValue("DigitsColorG",g);
    sett.setValue("DigitsColorB",b);
    sett.setValue("DigitsColorA",a);
}

//get show seconds flag
bool dclocksettings::getShowSeconds() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("ShowSeconds",true).toBool();
}

//set show seconds flag
void dclocksettings::setShowSeconds(const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("ShowSeconds",aShow);
}

//get time format
int dclocksettings::getTimeFormat() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("TimeFormat",0).toInt();
}

//set time format
void dclocksettings::setTimeFormat(const int &aFormatIdx) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("TimeFormat",aFormatIdx);
}

//get LCD
bool dclocksettings::getLcd() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    return sett.value("LcdFormat",true).toBool();
}

//set LCD
void dclocksettings::setLcd(const bool &aLcd) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("LcdFormat",aLcd);
}

//get font
QFont dclocksettings::getFont() const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    QFont fnt;
    fnt.setFamily(sett.value("FontFamily",QString("Helvetica")).toString());
    fnt.setBold(sett.value("FontBold",false).toBool());
    fnt.setItalic(sett.value("FontItalic",false).toBool());
    return fnt;
}

//set font
void dclocksettings::setFont(const QFont &aFont) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("FontFamily",aFont.family());
    sett.setValue("FontBold",aFont.bold());
    sett.setValue("FontItalic",aFont.italic());
}

//get blinking
bool dclocksettings::getBlinking() const
{
    QSettings sett(organizationName,applicationName);
    return sett.value("DelimBlinking",true).toBool();
}

//set blinking
void dclocksettings::setBlinking(const bool &aBlink) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("DelimBlinking",aBlink);
}

//get time zone
int dclocksettings::getTZoffset() const
{
    QSettings sett(organizationName,applicationName);
    return sett.value("TimeZoneOffset",-50000).toInt();
}

//set time zone
void dclocksettings::setTZoffset(const int &aOffset) const
{
    QSettings sett(organizationName,applicationName);
    sett.setValue("TimeZoneOffset",aOffset);
}
