#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "dclocksettings.h"

#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    ui->labelColor->setAutoFillBackground(true);
/*    m_aboutButton = new QPushButton(tr("&About"));
    m_aboutQtButton = new QPushButton(tr("&Qt About"));
    connect(m_aboutButton,SIGNAL(clicked()),this,SLOT(showAbout()));
    connect(m_aboutQtButton,SIGNAL(clicked()),this,SLOT(showQtAbout()));
    ui->buttonBox->addButton(m_aboutButton, QDialogButtonBox::ActionRole);
    ui->buttonBox->addButton(m_aboutQtButton, QDialogButtonBox::ActionRole);
    ui->buttonBox->addButton(QDialogButtonBox::Ok);
    ui->buttonBox->addButton(QDialogButtonBox::Cancel);
    ui->buttonBox->*/
    buildFontList();
    ui->chbBold->setEnabled(false);
    ui->chbItalic->setEnabled(false);
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::Window), this);
    if (newColor.isValid())
        {
//            ui->label->setText(newColor.name());
            ui->labelColor->setPalette(QPalette(newColor));
//            ui->labelColor->setAutoFillBackground(true);
        }
}

void SettingsDialog::dumpSettings() const
{
    dclocksettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::Window));
    dclocksettings::getInstance().setShowSeconds(ui->checkBox->isChecked());
    dclocksettings::getInstance().setTimeFormat(ui->cbTimeFormat->currentIndex());
    int w = ui->spinWidth->value();
    int h = ui->spinHeight->value();
    dclocksettings::getInstance().setSize(QSize(w,h));
    if (ui->cbFont->currentIndex() == 0)
        dclocksettings::getInstance().setLcd(true);
    else
        dclocksettings::getInstance().setLcd(false);
    QFont fnt;
    fnt.setFamily(ui->cbFont->currentText());
    fnt.setBold(ui->chbBold->isChecked());
    fnt.setItalic(ui->chbItalic->isChecked());
    dclocksettings::getInstance().setFont(fnt);
}

void SettingsDialog::loadSettings()
{
    QColor dColor = dclocksettings::getInstance().getColor();
    ui->labelColor->setPalette(QPalette(dColor));
    ui->checkBox->setChecked(dclocksettings::getInstance().getShowSeconds());
    ui->cbTimeFormat->setCurrentIndex(dclocksettings::getInstance().getTimeFormat());
    QSize wSize = dclocksettings::getInstance().getSize();
    ui->spinWidth->setValue(wSize.width());
    ui->spinHeight->setValue(wSize.height());
    if (dclocksettings::getInstance().getLcd())
        ui->cbFont->setCurrentIndex(0);
    else
    {
        bool found = false;
        QFont fnt(dclocksettings::getInstance().getFont());
        QString fnt_family(fnt.family());
        for (int i = 1; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            ui->cbFont->setCurrentIndex(i);
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setEnabled(true);
            ui->chbItalic->setEnabled(true);
            ui->chbBold->setChecked(fnt.bold());
            ui->chbItalic->setChecked(fnt.italic());
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QMessageBox::about(this, tr("About DigiClock"),
                        tr("<b>DigiClock</b> 0.2.2<br>"
                        "Using <b>Qt 4.6.2</b><br>"
                        "Copyright (c) 2010 Avis<br>"
                        "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a><br><br>"
                        "Desktop widget, showing digital time"));
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    if (aIndex == 0)
    {
        ui->chbBold->setEnabled(false);
        ui->chbItalic->setEnabled(false);
    }
    else
    {
        ui->chbBold->setEnabled(true);
        ui->chbItalic->setEnabled(true);
    }
}
