#include <QtGui>
#include "fontclock.h"

FontClock::FontClock(QColor &aColor, QString &aFormat, QFont &aFont, QWidget *parent) :
    QWidget(parent), m_font(aFont), m_color(aColor), m_format(aFormat)
{
    QSize aa = parent->size();
    resize(aa);
    setAttribute(Qt::WA_TranslucentBackground);
    calcFontSize();
    showTime();
}

void FontClock::calcFontSize()
{
    int wd_width = size().width();
    int wd_hgt = size().height();

    QTime time = QTime::currentTime();
    m_text = time.toString(m_format);

    QString fFamily = m_font.family();
    // calc font size
    for (int i = 0; i < 200; i++)
    {
        QFont f(fFamily,i);
        QFontMetrics fm(f);

        int x = fm.width(m_text);
        int y = fm.height();

        if ((x > wd_width) || (y > wd_hgt))
        {
            m_fntSize = i-1;
            break;
        }
    }
    m_font.setPointSize(m_fntSize);
}

void FontClock::showTime()
{
    QTime time = QTime::currentTime();
    m_text = time.toString(m_format);
    update();
}

void FontClock::paintEvent(QPaintEvent* /*event*/)
{
    QPainter p(this);
    p.setFont(m_font);
    p.setPen(m_color);

    p.drawText(rect(), Qt::AlignCenter, m_text);
}
