#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "dclocksettings.h"

#include <QColorDialog>
#include <QColor>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    ui->labelColor->setAutoFillBackground(true);
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::Window), this);
    if (newColor.isValid())
        {
//            ui->label->setText(newColor.name());
            ui->labelColor->setPalette(QPalette(newColor));
//            ui->labelColor->setAutoFillBackground(true);
        }
}

void SettingsDialog::dumpSettings() const
{
    dclocksettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::Window));
    dclocksettings::getInstance().setShowSeconds(ui->checkBox->isChecked());
    int w = ui->spinWidth->value();
    int h = ui->spinHeight->value();
    dclocksettings::getInstance().setSize(QSize(w,h));
}

void SettingsDialog::loadSettings()
{
    QColor dColor = dclocksettings::getInstance().getColor();
    ui->labelColor->setPalette(QPalette(dColor));
    ui->checkBox->setChecked(dclocksettings::getInstance().getShowSeconds());
    QSize wSize = dclocksettings::getInstance().getSize();
    ui->spinWidth->setValue(wSize.width());
    ui->spinHeight->setValue(wSize.height());
}
