#include <QtGui>

#include "digitalclockwdg.h"
#include "settingsdialog.h"
#include "dclocksettings.h"

DigitalClockWdg::DigitalClockWdg(QWidget *parent)
    : QLCDNumber(parent)
{
    setSegmentStyle(Filled);

    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(showTime()));
    setAttribute(Qt::WA_TranslucentBackground);

    // default values
//    m_digitColor = Qt::white;
//    m_showSeconds = true;
//    m_size = QSize(300,80);
//    m_timer_tick = 10000; // update widget interval
    loadSettings();
//    m_timer->start(m_timer_tick);
    showTime();
    setWindowTitle(tr("Digital Clock Widget"));
}

void DigitalClockWdg::showTime()
{
//        m_timer->stop();
//    showSettingsDialog();
    QTime time = QTime::currentTime();
    QString text;
    if (m_showSeconds)
        text = time.toString("hh:mm:ss");
    else
        text = time.toString("hh:mm");
    display(text);
}

void DigitalClockWdg::showSettingsDialog()
    {
//    SettingsDialog dialog((QWidget*)parent());
//    dialog. .resize(width(),height());

//    if (!dialog) {
  //           dialog = new SettingsDialog(this);
//             connect(findDialog, SIGNAL(findNext()), this, SLOT(findNext()));
    //     }
    SettingsDialog dialog(0);

//    dialog->setWindowModality(Qt::ApplicationModal);
  //  dialog->show();
//    dialog->raise();
  //  dialog->activateWindow();


//    dialog.setWindowModality(Qt::ApplicationModal);
    if (dialog.exec() == QDialog::Accepted) {

        dialog.dumpSettings();
        loadSettings();
    }
}

void DigitalClockWdg::loadSettings()
{
    m_digitColor = dclocksettings::getInstance().getColor();
    m_showSeconds = dclocksettings::getInstance().getShowSeconds();
    m_size = dclocksettings::getInstance().getSize();

    if (m_showSeconds)
    {
        setDigitCount(8);
        m_timer_tick = 1000;
    }
    else
    {
        setDigitCount(5);
        m_timer_tick = 5000;
    }
    m_timer->stop();
    m_timer->start(m_timer_tick);
    QPalette qp;
    qp.setColor(QPalette::WindowText,m_digitColor );
    qp.setColor(QPalette::Window,Qt::transparent );
    setPalette(qp);
    int x = geometry().x();
    int y = geometry().y();
    setGeometry(x,y,m_size.width(),m_size.height());
    //resize(m_size);
}

void DigitalClockWdg::homeScreenChanged(bool isOnCurrentHomescreen)
{
    if (isOnCurrentHomescreen)
    {
        if (!m_timer->isActive())
            m_timer->start(m_timer_tick);
        showTime();
    }
    else
        m_timer->stop();
}


