#include <QApplication>
#include <QLibraryInfo>
#include <QTranslator>
#include <QLocale>

#include "digitalclockwdg.h"
#if defined(Q_WS_MAEMO_5)
#include "qmaemo5homescreenadaptor.h"
#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
         QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    QTranslator myappTranslator;
    myappTranslator.load("digiclock_" + QLocale::system().name(),"/opt/digiclockwidget");
    app.installTranslator(&myappTranslator);

    DigitalClockWdg clock;
#if  defined(Q_WS_MAEMO_5)
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&clock);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &clock, SLOT(showSettingsDialog()));
    QObject::connect(adaptor, SIGNAL(homescreenChanged(bool)), &clock, SLOT(homeScreenChanged(bool)));
    clock.setLineWidth(0);
    clock.show();
#else
    clock.show();
#endif
    return app.exec();
}
