#ifndef DICE_H
#define DICE_H

#include <QDebug>
#include <QObject>
#include <QVector>
#include "die.h"

class Dice : public QObject
{
    Q_OBJECT
private:
    static int instances;
    QVector <Die* > dice;
public:
    explicit Dice(QObject *parent = 0);
    virtual ~Dice();
    QVector<Die* > const& getDice() const;

public slots:
    void slotAddDie(int eyes);
    void slotClearDie();
    void slotRemoveDie(Die * die);

signals:
    void signalDieAdded(Die const* die);
    void signalDieCleared();
    void signalDieRemoved();
};

#endif // DICE_H
