#include "dice.h"

int Dice::instances = 0;

/**
 * Constructor.
 *
 * @fn Dice
 */
Dice::Dice(QObject *parent) :
        QObject(parent)
{
    ++instances;
    qDebug() << "Dice instances:" << instances;
}

/**
 * Destructor. All dice are removed from the heap.
 *
 * @fn ~Dice
 */
Dice::~Dice()
{
    --instances;
    qDebug() << "Dice instances left:" << instances;
}

/**
 * Return a Vector with pointers to all Die objects.
 *
 * @fn getDice
 * @return QVector<Die* > all pointers to Die objects.
 */
QVector<Die* > const& Dice::getDice() const
{
    return dice;
}

/**
 * Add a new Die.
 *
 * @fn slotAddDie
 * @param int eyes - the number of eyes of the new Die.
 */
void Dice::slotAddDie(int eyes)
{
    // Die with this as parent ensure that the Die object will be deleted as soon as this
    // is deleted.
    Die* die = new Die(eyes, this);
    dice.append(die);
    emit signalDieAdded(die);
}

/**
 * Remove all dice from the Collection.
 *
 * @fn slotClearDie
 */
void Dice::slotClearDie()
{
    qDebug() << "Clear die";
    // No need to worry about deletion of Die objects from memory. It will be taken care of
    // when this instance is deleted.
    dice.clear();
    emit signalDieCleared();
}

/**
 * Remove the given die from the Collection.
 *
 * @fn slotRemoveDie
 * @param Die * die - pointer to the Die object to be removed.
 */
void Dice::slotRemoveDie(Die * die)
{
    qDebug() << "Remove die:" << die->getEyes();
    dice.remove(dice.indexOf(die));
    emit signalDieRemoved();
}
