#ifndef ACCELEROMETERPOLLER_H
#define ACCELEROMETERPOLLER_H

#include <QThread>
#include <QAccelerometer>
#include <QDebug>
#include <QAccelerometerReading>
//#include <QtDBus/QDBusConnection>
//#include <QtDBus/QDBusPendingReply>

QTM_USE_NAMESPACE

class AccelerometerPoller : public QThread
{
    Q_OBJECT
private:
    static int instances;
    int dataRate;
    int hz;
    bool poll;

    QAccelerometer sensor;

    void initSensor();

public:
    explicit AccelerometerPoller(int dataRate = 1, QObject *parent = 0);
    virtual ~AccelerometerPoller();
    void run();
    void read();
    void stop();
    void setDataRate(int dataRate);
signals:
    void signalSensorReading(QAccelerometerReading * reading);
public slots:

};

#endif // ACCELEROMETERPOLLER_H
