#ifndef DICESETEDIT_H
#define DICESETEDIT_H

/*
  DiceJinni - A dice simulator
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include "Configuration.h"

class DicesModel : public Lum::Model::StdRefTable<Dice>
{
private:
  class DataProvider : public Lum::Model::StdRefTable<Dice>::DataProvider
  {
  public:
    std::wstring GetString(const Iterator& iter, size_t column) const
    {
      std::wstring string;

      for (size_t i=0; i<iter->values.size(); i++) {
        if (i>0) {
          string.append(L", ");
        }

        string.append(L"'"+iter->values[i].value+L"'");
      }

      return string;
    };
  };

public:
  DicesModel(std::list<Dice>& list)
  : Lum::Model::StdRefTable<Dice>(list,new DataProvider())
  {
    // no code
  }
};

typedef Lum::Base::Reference<DicesModel> DicesModelRef;

class DiceSetEdit : public Lum::Dlg::ActionDialog
{
private:
  DiceSet&                           diceSet;

  Lum::Model::StringRef              name;
  DicesModelRef                      dicesModel;

  Lum::Model::SingleLineSelectionRef selection;

  Lum::Model::ActionRef              addAction;
  Lum::Model::ActionRef              editAction;
  Lum::Model::ActionRef              cloneAction;
  Lum::Model::ActionRef              removeAction;

  Lum::Model::ActionRef              okAction;

  bool                               result;

private:
  void EvaluateRights();

public:
  DiceSetEdit(DiceSet& diceSet);

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);

  bool GetResult() const;
};

#endif
