#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
  DiceJinni - A dice simulator
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string>
#include <list>
#include <vector>

#include <Lum/Model/Integer.h>
#include <Lum/Model/Table.h>

class Value
{
public:
  std::wstring value;
};

class Dice
{
public:
  bool               canStay;
  bool               stays;
  std::vector<Value> values;
  std::wstring       value;

public:
  Dice();
};

class DiceSet
{
public:
  std::wstring    name;
  std::list<Dice> dices;
  //bool            maxThrows;

  bool operator<(const DiceSet& set) const;
};

class DiceSetModel : public Lum::Model::StdRefTable<DiceSet>
{
private:
  class DataProvider : public Lum::Model::StdRefTable<DiceSet>::DataProvider
  {
  public:
    std::wstring GetString(const Iterator& iter, size_t column) const
    {
      return iter->name;
    };
  };

public:
  DiceSetModel(std::list<DiceSet>& list)
  : Lum::Model::StdRefTable<DiceSet>(list,new DataProvider())
  {
    // no code
  }
};

typedef Lum::Base::Reference<DiceSetModel> DiceSetModelRef;

extern std::list<DiceSet>   sets;
extern DiceSetModelRef      setsModel;
extern bool                 configurationChanged;
extern Lum::Model::SizeTRef currentSet;

extern bool LoadConfig();
extern bool SaveConfig();

#endif
