#ifndef GAMEAREA_H
#define GAMEAREA_H

/*
  DiceJinni - A dice simulator
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/OS/Bitmap.h>

class GameArea : public Lum::Scrollable
{
private:
  Lum::OS::Bitmap   *area;           //! The area background including area foreground
  Lum::OS::ColorRef backgroundColor;
  Lum::OS::ColorRef cellBackgroundColor;
  Lum::OS::ColorRef normalFrameColor;
  Lum::OS::ColorRef staysFrameColor;
  Lum::OS::ColorRef textColor;
  Lum::OS::FontRef  font;
  size_t            cellSize;
  size_t            distance;
  size_t            columns;
  size_t            areaWidth;
  size_t            areaHeight;

private:
  void UpdateDimensions();
  void CalcAreaSize();
  void RebuildArea();
  void RedrawArea();

public:
  GameArea(bool horizontalFlex=false, bool verticalFlex=false);
  ~GameArea();
  bool HandlesFocus() const;

  void CalcSize();

  void Draw(int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
