unit rlshopinv;
{$mode objfpc}
interface

uses sysutils, classes, rlgobj, rlglobal, rlitem, vlua;

type

{ TShopInventory }

TShopInventory = class( TGameObject )
  // General constructor
  constructor Create(const thingID :string); override;
  // Destructor
  destructor Destroy; override;
  // Stream constructor
  constructor CreateFromStream( ISt : TStream ); override;
  // Stream writer
  procedure ToStream( OSt : TStream ); override;
  // Add item
  procedure AddItem( Item : TItem );
  // Returns a property value
  function getProperty( PropertyID : Byte ) : Variant; override;
  // Sets a property value
  procedure setProperty( PropertyID : Byte; Value : Variant ); override;
  // Gets amount of non-nil items
  function getCount : DWord;
  // Will need to remove this
  procedure Callback(Index: byte);
  // Resorts the shop
  procedure Resort;

  // register lua functions
  class procedure RegisterLuaAPI( Lua : TLua );
public
  // Items
  Items : array[1..ITEMS_SHOP] of TItem;
  Level : Word;
end;

implementation

// Remove
uses rlui, rllua, rlgame;

{ TShopInventory }

constructor TShopInventory.Create(const thingID: string);
var Count : DWord;
    State : TRLLuaState;
begin
  inherited Create(thingID);
  for Count := 1 to ITEMS_SHOP do Items[Count] := nil;
  Level := 0;
  State.Init(Game.Lua.LuaState);
  State.RegisterNewSubObject( LuaIndex, Self, 'item', 'shop_item' );
end;

destructor TShopInventory.Destroy;
var Count : DWord;
begin
  for Count := 1 to ITEMS_SHOP do FreeAndNil( Items[Count] );
  inherited Destroy;
end;

constructor TShopInventory.CreateFromStream(ISt: TStream);
var Count, Size : DWord;
    Item : TItem;
    State : TRLLuaState;
begin
  inherited CreateFromStream(ISt);
  for Count := 1 to ITEMS_SHOP do Items[Count] := nil;
  Level := ISt.ReadWord;
  Size := ISt.ReadDWord;
  for Count := 1 to Size do
    AddItem(TItem.CreateFromStream(ISt));
  State.Init(Game.Lua.LuaState);
  State.RegisterNewSubObject( LuaIndex, Self, 'item', 'shop_item' );
end;

procedure TShopInventory.ToStream(OSt: TStream);
var Count, Size : DWord;
begin
  inherited ToStream(OSt);
  Resort;
  OSt.WriteWord(Level);
  Size := getCount;
  OSt.WriteDWord(Size);
  for Count := 1 to Size do
    Items[Count].ToStream(OSt);
end;

procedure TShopInventory.AddItem(Item: TItem);
var Count : DWord;
begin
  for Count := 1 to ITEMS_SHOP do
    if Items[Count] = nil then
    begin
      Items[Count] := Item;
      Exit;
    end;
end;

function TShopInventory.getProperty(PropertyID: Byte): Variant;
begin
  case PropertyID of
    PROP_LEVEL  : Exit( Level );
    PROP_AMOUNT : Exit( getCount );
  else
    Exit( inherited getProperty(PropertyID) );
  end;
end;

procedure TShopInventory.setProperty(PropertyID: Byte; Value: Variant);
begin
  case PropertyID of
    PROP_LEVEL  : Level := Value;
  else
    inherited setProperty(PropertyID, Value);
  end;
end;

function TShopInventory.getCount: DWord;
var Count : DWord;
begin
  getCount := 0;
  for Count := 1 to ITEMS_SHOP do
    if Items[Count] <> nil then
      Inc( getCount );
end;

procedure TShopInventory.Callback(Index: byte);
begin
  if index in [1..ITEMS_SHOP] then
    UI.UpdateStatus(Items[Index])
  else
    UI.UpdateStatus(nil);
end;

procedure TShopInventory.Resort;
var Count : DWord;
begin
  for Count := 1 to ITEMS_SHOP-1 do
    if Items[Count] = nil then
    begin
      Items[Count]     := Items[Count + 1];
      Items[Count + 1] := nil;
    end;
end;

function lua_shop_item_get(L: Plua_State): Integer; cdecl;
var State  : TRLLuaState;
    Shop   : TShopInventory;
    Slot   : Word;
begin
  State.ObjectInit(L,Shop);
  Slot := State.ToInteger(2);

  if (Slot = 0) or (Slot > ITEMS_SHOP)
    then State.Push( nil )
    else State.Push( Shop.Items[Slot] );
  Exit(1);
end;

function lua_shop_item_set(L: Plua_State): Integer; cdecl;
var State  : TRLLuaState;
    Slot   : Word;
    ID     : AnsiString;
    Shop   : TShopInventory;
begin
  State.ObjectInit(L,Shop);
  Slot := State.ToInteger(2);
  if (Slot = 0) or (Slot > ITEMS_SHOP) then Exit(0);
  FreeAndNil(Shop.Items[slot]);
  Shop.Items[slot] := State.ToObjectOrNil(3) as TItem;
  Exit(0);
end;

function lua_shop_sort(L: Plua_State): Integer; cdecl;
var State  : TRLLuaState;
    Shop   : TShopInventory;
begin
  State.ObjectInit(L,Shop);
  Shop.Resort;
  Exit(0);
end;


class procedure TShopInventory.RegisterLuaAPI(Lua: TLua);
begin
  Lua.SetTableFunction('shop','item_set',   @lua_shop_item_set);
  Lua.SetTableFunction('shop','item_get',   @lua_shop_item_get);
  Lua.SetTableFunction('shop','sort',       @lua_shop_sort);
end;

end.

